/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.crawler.page;

import java.util.ArrayList;
import java.util.List;
import net.vidageek.crawler.Page;
import net.vidageek.crawler.Status;
import net.vidageek.crawler.link.DefaultLinkFinder;
import net.vidageek.crawler.link.FrameLinkFinder;
import net.vidageek.crawler.link.IframeLinkFinder;

public class OkPage
implements Page {
    private final String url;
    private final String content;

    public OkPage(String url, String content) {
        if (url == null || url.trim().length() == 0) {
            throw new IllegalArgumentException("url cannot be null");
        }
        this.url = url;
        this.content = content;
    }

    @Override
    public List<String> getLinks() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(new DefaultLinkFinder(this.content).getLinks());
        list.addAll(new IframeLinkFinder(this.content).getLinks());
        list.addAll(new FrameLinkFinder(this.content).getLinks());
        return list;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public Status getStatusCode() {
        return Status.OK;
    }

    @Override
    public String getCharset() {
        return "UTF-8";
    }
}

