/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.crawler.queue;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public final class DelayedBlockingQueue
implements BlockingQueue<Runnable> {
    private final BlockingQueue<Runnable> queue;
    private final int delayInMilliseconds;
    private volatile long lastSuccesfullPop;

    public DelayedBlockingQueue(int delayInMilliseconds) {
        this.delayInMilliseconds = delayInMilliseconds;
        this.queue = new LinkedBlockingQueue<Runnable>();
        this.lastSuccesfullPop = System.currentTimeMillis() - (long)delayInMilliseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Runnable poll() {
        BlockingQueue<Runnable> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            while (System.currentTimeMillis() - this.lastSuccesfullPop <= (long)this.delayInMilliseconds && !this.queue.isEmpty()) {
                this.sleep();
            }
            this.lastSuccesfullPop = System.currentTimeMillis();
            return (Runnable)this.queue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
        BlockingQueue<Runnable> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            while (System.currentTimeMillis() - this.lastSuccesfullPop <= (long)this.delayInMilliseconds && !this.queue.isEmpty()) {
                this.sleep();
            }
            this.lastSuccesfullPop = System.currentTimeMillis();
            return this.queue.poll(timeout, unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Runnable take() throws InterruptedException {
        BlockingQueue<Runnable> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            while (System.currentTimeMillis() - this.lastSuccesfullPop <= (long)this.delayInMilliseconds && !this.queue.isEmpty()) {
                this.sleep();
            }
            this.lastSuccesfullPop = System.currentTimeMillis();
            return this.queue.take();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Runnable remove() {
        BlockingQueue<Runnable> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            while (System.currentTimeMillis() - this.lastSuccesfullPop <= (long)this.delayInMilliseconds && !this.queue.isEmpty()) {
                this.sleep();
            }
            this.lastSuccesfullPop = System.currentTimeMillis();
            return (Runnable)this.queue.remove();
        }
    }

    private void sleep() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean add(Runnable e) {
        return this.queue.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends Runnable> c) {
        return this.queue.addAll(c);
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.queue.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.queue.containsAll(c);
    }

    @Override
    public int drainTo(Collection<? super Runnable> c, int maxElements) {
        return this.queue.drainTo(c, maxElements);
    }

    @Override
    public int drainTo(Collection<? super Runnable> c) {
        return this.queue.drainTo(c);
    }

    @Override
    public Runnable element() {
        return (Runnable)this.queue.element();
    }

    @Override
    public boolean equals(Object o) {
        return this.queue.equals(o);
    }

    @Override
    public int hashCode() {
        return this.queue.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public Iterator<Runnable> iterator() {
        return this.queue.iterator();
    }

    @Override
    public boolean offer(Runnable e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.offer(e, timeout, unit);
    }

    @Override
    public boolean offer(Runnable e) {
        return this.queue.offer(e);
    }

    @Override
    public Runnable peek() {
        return (Runnable)this.queue.peek();
    }

    @Override
    public void put(Runnable e) throws InterruptedException {
        this.queue.put(e);
    }

    @Override
    public int remainingCapacity() {
        return this.queue.remainingCapacity();
    }

    @Override
    public boolean remove(Object o) {
        return this.queue.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.queue.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.queue.retainAll(c);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.queue.toArray(a);
    }
}

