/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.crawler.visitor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.vidageek.crawler.Page;
import net.vidageek.crawler.PageVisitor;
import net.vidageek.crawler.Status;
import net.vidageek.crawler.Url;

public final class DoesNotFollowVisitedUrlVisitor
implements PageVisitor {
    private final PageVisitor visitor;
    private final Map<Url, String> visitedUrls = new ConcurrentHashMap<Url, String>();

    public DoesNotFollowVisitedUrlVisitor(String beginUrl, PageVisitor visitor) {
        this.visitor = visitor;
        this.visitedUrls.put(new Url(beginUrl, 0), "");
    }

    @Override
    public boolean followUrl(Url url) {
        if (this.visitedUrls.get(url) != null) {
            return false;
        }
        this.visitedUrls.put(url, "");
        return this.visitor.followUrl(url);
    }

    @Override
    public void onError(Url url, Status statusError) {
        this.visitor.onError(url, statusError);
    }

    @Override
    public void visit(Page page) {
        this.visitor.visit(page);
    }
}

