/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.crawler.visitor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.vidageek.crawler.ContentVisitor;
import net.vidageek.crawler.Page;
import net.vidageek.crawler.PageVisitor;
import net.vidageek.crawler.Status;
import net.vidageek.crawler.Url;

public class DomainVisitor
implements PageVisitor {
    private final String domain;
    private final ContentVisitor visitor;

    public DomainVisitor(String baseUrl, ContentVisitor visitor) {
        this.visitor = visitor;
        if (baseUrl == null || baseUrl.trim().length() == 0) {
            throw new IllegalArgumentException("baseUrl cannot be null or empty");
        }
        Matcher matcher = Pattern.compile("(http://[^/]+)").matcher(baseUrl);
        if (!matcher.find()) {
            throw new IllegalArgumentException("baseUrl must match http://[^/]+");
        }
        this.domain = matcher.group(1) + "/";
    }

    @Override
    public boolean followUrl(Url url) {
        if (url == null) {
            return false;
        }
        return url.link().startsWith(this.domain);
    }

    @Override
    public void onError(Url url, Status statusError) {
        this.visitor.onError(url, statusError);
    }

    @Override
    public void visit(Page page) {
        this.visitor.visit(page);
    }
}

