/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.crawler.visitor;

import net.vidageek.crawler.Page;
import net.vidageek.crawler.PageVisitor;
import net.vidageek.crawler.Status;
import net.vidageek.crawler.Url;

public final class RejectAtDepthVisitor
implements PageVisitor {
    private final PageVisitor visitor;
    private final int depth;

    public RejectAtDepthVisitor(int depth, PageVisitor visitor) {
        this.depth = depth;
        this.visitor = visitor;
    }

    @Override
    public boolean followUrl(Url url) {
        if (url.depth() > this.depth) {
            return false;
        }
        return this.visitor.followUrl(url);
    }

    @Override
    public void onError(Url errorUrl, Status statusError) {
        this.visitor.onError(errorUrl, statusError);
    }

    @Override
    public void visit(Page page) {
        this.visitor.visit(page);
    }
}

