/**
 * 
 */
package net.vidageek.mirror;

import net.vidageek.mirror.get.GetterHandler;
import net.vidageek.mirror.invoke.InvocationHandler;
import net.vidageek.mirror.reflect.AllReflectionHandler;
import net.vidageek.mirror.reflect.ReflectionHandler;
import net.vidageek.mirror.set.SetterHandler;

/**
 * @author jonasabreu
 * 
 */
public class ClassController<T> {

	private final Class<T> clazz;

	public ClassController(final Class<T> clazz) {
		if (clazz == null) {
			throw new IllegalArgumentException("clazz cannot be null");
		}
		this.clazz = clazz;
	}

	public InvocationHandler<T> invoke() {
		return new InvocationHandler<T>(clazz);
	}

	public SetterHandler set() {
		return new SetterHandler(clazz);
	}

	public GetterHandler get() {
		return new GetterHandler(clazz);
	}

	public ReflectionHandler<T> reflect() {
		return new ReflectionHandler<T>(clazz);
	}

	public AllReflectionHandler<T> reflectAll() {
		return new AllReflectionHandler<T>(clazz);
	}

}
