package net.vidageek.mirror;

/**
 * 
 * @author jonasabreu
 * 
 */
public abstract class Mirror {

	private Mirror() {
	}

	public static Class<?> reflectClass(final String className) {

		if (className == null || className.trim().length() == 0) {
			throw new IllegalArgumentException(
					"className cannot be null or empty");
		}

		try {
			return Class.forName(className);
		} catch (ClassNotFoundException e) {
			throw new MirrorException("class " + className
					+ " could not be found.", e);
		}
	}

	public static <T> ClassController<T> on(final Class<T> clazz) {
		return new ClassController<T>(clazz);

	}

	public static ObjectController on(final Object object) {
		return new ObjectController(object);
	}

	public static ClassController<?> on(final String className) {
		return on(reflectClass(className));
	}

}
