/**
 * 
 */
package net.vidageek.mirror;

import net.vidageek.mirror.get.GetterHandler;
import net.vidageek.mirror.invoke.InvocationHandler;
import net.vidageek.mirror.set.SetterHandler;

/**
 * @author jonasabreu
 * 
 */
public class ObjectController {

	private final Object target;

	public ObjectController(final Object target) {
		if (target == null) {
			throw new IllegalArgumentException("target cannot be null");
		}
		this.target = target;
	}

	public InvocationHandler<Object> invoke() {
		return new InvocationHandler<Object>(target);
	}

	public SetterHandler set() {
		return new SetterHandler(target);
	}

	public GetterHandler get() {
		return new GetterHandler(target);
	}

}
