package net.vidageek.mirror.invoke;

import static net.vidageek.mirror.Mirror.on;

import java.lang.reflect.Constructor;
import java.util.Arrays;

import net.vidageek.mirror.MirrorException;

/**
 * 
 * @author jonasabreu
 * 
 */

// TODO Must provide a way to call a constructor using classes to avoid
// ambiguity of primitive types
public class ConstructorHandlerByArgs<T> implements ConstructorHandler<T> {

	private final Class<T> clazz;

	public ConstructorHandlerByArgs(final Class<T> clazz) {
		if (clazz == null) {
			throw new IllegalArgumentException("Argument class cannot be null");
		}
		this.clazz = clazz;
	}

	public T withoutArgs() {
		return this.withArgs(new Object[0]);
	}

	public T withArgs(final Object... args) {
		return new ConstructorHandlerByConstructor<T>(clazz,
				getConstructor(args)).withArgs(args);
	}

	private Constructor<T> getConstructor(final Object... args) {
		int length = args == null ? 0 : args.length;

		Class<?>[] classes = new Class<?>[length];
		for (int i = 0; i < length; i++) {
			classes[i] = args[i].getClass();
		}

		Constructor<T> con = on(clazz).reflect().constructor()
				.withArgs(classes);
		if (con == null) {
			throw new MirrorException("Could not find constructor with args "
					+ Arrays.asList(classes) + " on class "
					+ this.clazz.getName());
		}

		return con;

	}

}
