/**
 * 
 */
package net.vidageek.mirror.invoke;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import net.vidageek.mirror.MirrorException;

/**
 * @author jonasabreu
 * 
 */
public class ConstructorHandlerByConstructor<T> implements
		ConstructorHandler<T> {

	private final Constructor<T> constructor;
	private final Class<?> clazz;

	/**
	 * @param clazz
	 * @param con
	 */
	public ConstructorHandlerByConstructor(final Class<?> clazz,
			final Constructor<T> con) {
		if (clazz == null) {
			throw new IllegalArgumentException("clazz cannot be null");
		}
		if (con == null) {
			throw new IllegalArgumentException("constructor cannot be null");
		}
		if (!clazz.equals(con.getDeclaringClass())) {
			throw new IllegalArgumentException(
					"constructor declaring type should be " + clazz.getName()
							+ " but was " + con.getDeclaringClass().getName());
		}
		this.clazz = clazz;
		this.constructor = con;
	}

	@Override
	public T withArgs(final Object... args) {
		try {
			constructor.setAccessible(true);
			return constructor.newInstance(args);
		} catch (IllegalArgumentException e) {
			throw new MirrorException("could not invoke constructor "
					+ constructor.toGenericString() + " on class "
					+ clazz.getName(), e);
		} catch (InstantiationException e) {
			throw new MirrorException("could not invoke constructor "
					+ constructor.toGenericString() + " on class "
					+ clazz.getName(), e);
		} catch (IllegalAccessException e) {
			throw new MirrorException("could not invoke constructor "
					+ constructor.toGenericString() + " on class "
					+ clazz.getName(), e);
		} catch (InvocationTargetException e) {
			throw new MirrorException("could not invoke constructor "
					+ constructor.toGenericString() + " on class "
					+ clazz.getName(), e.getCause() == null ? e : e.getCause());
		}

	}

	@Override
	public T withoutArgs() {
		return withArgs(new Object[0]);
	}

}
