package net.vidageek.mirror.invoke;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

/**
 * 
 * @author jonasabreu
 * 
 */
public class InvocationHandler<T> {

	private final Object target;
	private final Class<?> clazz;

	public InvocationHandler(final Object target) {
		if (target == null) {
			throw new IllegalArgumentException("target can't be null");
		}
		this.target = target;
		clazz = target.getClass();
	}

	public InvocationHandler(final Class<T> target) {
		if (target == null) {
			throw new IllegalArgumentException("target can't be null");
		}
		clazz = target;
		this.target = null;
	}

	public MethodHandler method(final String methodName) {
		if (methodName == null) {
			throw new IllegalArgumentException("methodName can't be null");
		}
		return new MethodHandlerByName(target, clazz, methodName);
	}

	@SuppressWarnings("unchecked")
	public ConstructorHandler<T> constructor() {
		if (this.target != null) {
			throw new IllegalStateException(
					"must use constructor InvocationHandler(Class<T>) instead of InvocationHandler(Object).");
		}
		return new ConstructorHandlerByArgs<T>((Class<T>) clazz);
	}

	public MethodHandler method(final Method method) {
		return new MethodHandlerByMethod(target, clazz, method);
	}

	public <C> ConstructorHandler<C> constructor(final Constructor<C> con) {
		return new ConstructorHandlerByConstructor<C>(clazz, con);
	}
}
