/**
 * 
 */
package net.vidageek.mirror.invoke;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

import net.vidageek.mirror.MirrorException;

/**
 * @author jonasabreu
 * 
 */
public class MethodHandlerByMethod implements MethodHandler {

	private final Object target;
	private final Class<?> clazz;
	private final Method method;

	public MethodHandlerByMethod(final Object target, final Class<?> clazz,
			final Method method) {

		if (clazz == null) {
			throw new IllegalArgumentException("clazz cannot be null");
		}
		if (method == null) {
			throw new IllegalArgumentException("method cannot be null");
		}
		if (!method.getDeclaringClass().isAssignableFrom(clazz)) {
			throw new IllegalArgumentException("method " + method
					+ " cannot be invoked on clazz " + clazz.getName());
		}
		this.target = target;
		this.clazz = clazz;
		this.method = method;
	}

	@Override
	public Object withArgs(final Object... args) {
		if (target == null && !Modifier.isStatic(method.getModifiers())) {
			throw new IllegalStateException("attempt to call instance method "
					+ method.getName() + " on class " + clazz.getName());
		}

		try {
			method.setAccessible(true);
			return method.invoke(target, args);

		} catch (IllegalArgumentException e) {
			throw new MirrorException("Could not invoke method "
					+ method.getName(), e);
		} catch (IllegalAccessException e) {
			throw new MirrorException("Could not invoke method "
					+ method.getName(), e);
		} catch (InvocationTargetException e) {
			throw new MirrorException("Could not invoke method "
					+ method.getName(), e.getCause() == null ? e : e.getCause());
		} catch (NullPointerException e) {
			throw new MirrorException("Attempt to call an instance method ( "
					+ method.getName() + ") on a null object.", e);
		}
	}

	@Override
	public Object withoutArgs() {
		return withArgs(new Object[0]);
	}

}
