package net.vidageek.mirror.invoke;

import static net.vidageek.mirror.Mirror.on;

import java.lang.reflect.Method;

import net.vidageek.mirror.MirrorException;

/**
 * 
 * @author jonasabreu
 * 
 */
// TODO Must provide a way to call a method using classes to avoid ambiguity of
// primitive types
public class MethodHandlerByName implements MethodHandler {

	private final Object target;
	private final String methodName;
	private final Class<?> clazz;

	public MethodHandlerByName(final Object target, final Class<?> clazz,
			final String methodName) {
		if (clazz == null) {
			throw new IllegalArgumentException("clazz can't be null");
		}

		if (methodName == null || methodName.trim().length() == 0) {
			throw new IllegalArgumentException("methodName can't be null");
		}

		this.target = target;
		this.clazz = clazz;
		this.methodName = methodName;
	}

	public Object withoutArgs() {
		return withArgs(new Object[0]);
	}

	public Object withArgs(final Object... args) {
		return new MethodHandlerByMethod(target, clazz, getMethod(args))
				.withArgs(args);
	}

	private Method getMethod(final Object[] args) {
		int length = args == null ? 0 : args.length;

		Class<?>[] classes = new Class<?>[length];
		for (int i = 0; i < length; i++) {
			classes[i] = args[i].getClass();
		}

		Method method = on(clazz).reflect().method(methodName)
				.withArgs(classes);
		if (method == null) {
			throw new MirrorException("Could not find method " + methodName
					+ " on class " + clazz.getName());
		}
		return method;

	}

}
