package net.vidageek.mirror.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;

public class AllAnnotationsHandler {

	private final Class<?> clazz;

	public AllAnnotationsHandler(final Class<?> clazz) {
		if (clazz == null) {
			throw new IllegalArgumentException("Argument clazz cannot be null.");
		}
		this.clazz = clazz;
	}

	public List<Annotation> atClass() {
		return Arrays.asList(clazz.getAnnotations());
	}

	public List<Annotation> atField(final String fieldName) {
		Field field = new FieldReflector(fieldName).onClass(clazz);
		if (field == null) {
			return null;
		}
		return Arrays.asList(field.getAnnotations());
	}

	public AllMethodAnnotationsHandler atMethod(final String methodName) {
		return new AllMethodAnnotationsHandler(clazz, methodName);
	}

}
