package net.vidageek.mirror.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class AllMethodAnnotationsHandler {

	private final Class<?> clazz;
	private final String methodName;

	public AllMethodAnnotationsHandler(final Class<?> clazz,
			final String methodName) {
		if (clazz == null) {
			throw new IllegalArgumentException("Argument clazz cannot be null.");
		}
		if (methodName == null || methodName.trim().length() == 0) {
			throw new IllegalArgumentException(
					"Argument methodName cannot be null or blank.");
		}

		this.clazz = clazz;
		this.methodName = methodName.trim();
	}

	public List<Annotation> withoutArgs() {
		Method method = new MethodReflector(methodName, clazz).withoutArgs();
		if (method == null) {
			return null;
		}
		return Arrays.asList(method.getAnnotations());
	}

	public List<Annotation> withArgs(final Class<?>... classes) {
		Method method = new MethodReflector(methodName, clazz)
				.withArgs(classes);
		if (method == null) {
			return null;
		}
		return Arrays.asList(method.getAnnotations());
	}

}
