/**
 * 
 */
package net.vidageek.mirror.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author jonasabreu
 * 
 */
public class AllReflectionHandler<T> {

	private final Class<T> clazz;

	public AllReflectionHandler(final Class<T> clazz) {
		if (clazz == null) {
			throw new IllegalArgumentException("clazz cannot be null");
		}
		this.clazz = clazz;
	}

	public List<Field> fields() {
		Class<?> c = clazz;
		List<Field> list = new ArrayList<Field>();
		while (c.getSuperclass() != null) {
			list.addAll(Arrays.asList(c.getDeclaredFields()));
			c = c.getSuperclass();
		}
		list.addAll(Arrays.asList(Object.class.getDeclaredFields()));
		return list;
	}

	public List<Method> methods() {
		Class<?> c = clazz;
		List<Method> list = new ArrayList<Method>();
		while (c.getSuperclass() != null) {
			list.addAll(Arrays.asList(c.getDeclaredMethods()));
			c = c.getSuperclass();
		}
		list.addAll(Arrays.asList(Object.class.getDeclaredMethods()));
		return list;
	}

	// If somebody can tell me why on earth getDeclaredConstructors return
	// Constructor<?>[], I would be really glad.
	@SuppressWarnings("unchecked")
	public List<Constructor<T>> constructors() {
		return (List) Arrays.asList(clazz.getDeclaredConstructors());
	}

	public AllAnnotationsHandler annotations() {
		return new AllAnnotationsHandler(clazz);
	}

}
