package net.vidageek.mirror.reflect;

import java.lang.annotation.Annotation;

public class AnnotationHandler {

	private final Class<?> clazz;
	private final Class<? extends Annotation> annotation;

	public AnnotationHandler(Class<?> clazz,
			Class<? extends Annotation> annotation) {
		if (clazz == null) {
			throw new IllegalArgumentException("Argument clazz cannot be null.");
		}
		if (annotation == null) {
			throw new IllegalArgumentException(
					"Argument annotation cannot be null.");
		}
		this.clazz = clazz;
		this.annotation = annotation;
	}

	public Annotation atField(String fieldName) {
		if (fieldName == null || fieldName.trim().length() == 0) {
			throw new IllegalArgumentException(
					"fieldName cannot be null or empty.");
		}
		return new FieldReflector(fieldName).onClass(clazz).getAnnotation(
				annotation);
	}

	public MethodAnnotationHandler atMethod(String methodName) {
		return new MethodAnnotationHandler(clazz, methodName, annotation);
	}

	public Annotation atClass() {
		return clazz.getAnnotation(annotation);
	}

}
