/**
 * 
 */
package net.vidageek.mirror.reflect;

import java.lang.reflect.Constructor;

import net.vidageek.mirror.matcher.ClassArrayMatcher;
import net.vidageek.mirror.matcher.MatchType;

import static net.vidageek.mirror.Mirror.on;

/**
 * @author jonasabreu
 * 
 */
public class ConstructorReflector<T> {

	private final Class<T> clazz;

	public ConstructorReflector(final Class<T> clazz) {
		if (clazz == null) {
			throw new IllegalArgumentException("argument class cannot be null.");
		}
		this.clazz = clazz;
	}

	public Constructor<T> withArgs(final Class<?>... classes) {
		if (classes == null) {
			throw new IllegalArgumentException("classes cannot be null");
		}

		return getConstructor(classes);
	}

	@SuppressWarnings("unchecked")
	private Constructor<T> getConstructor(final Class<?>... classes) {
		ClassArrayMatcher matcher = new ClassArrayMatcher(classes);
		Constructor<?> match = null;
		for (Constructor<?> con : on(clazz).reflectAll().constructors()) {
			MatchType matchType = matcher.match(con.getParameterTypes());
			if (matchType.equals(MatchType.PERFECT)) {
				match = con;
				break;
			} else if (matchType.equals(MatchType.MATCH)) {
				match = con;
			}
		}
		if (match != null) {
			match.setAccessible(true);
		}
		return (Constructor<T>) match;
	}

	public Constructor<T> withoutArgs() {
		return withArgs(new Class<?>[0]);
	}
}
