/**
 * 
 */
package net.vidageek.mirror.reflect;

import java.lang.reflect.Field;

import static net.vidageek.mirror.Mirror.on;

/**
 * @author jonasabreu
 * 
 */
public class FieldReflector {

	private final String fieldName;

	public FieldReflector(final String fieldName) {
		if (fieldName == null || fieldName.trim().length() == 0) {
			throw new IllegalArgumentException(
					"fieldName cannot be null or blank");
		}
		this.fieldName = fieldName;
	}

	public Field onClass(final Class<?> clazz) {
		if (clazz == null) {
			throw new IllegalArgumentException("argument clazz cannot be null.");
		}

		for (Field field : on(clazz).reflectAll().fields()) {
			if (fieldName.equals(field.getName())) {
				field.setAccessible(true);
				return field;
			}
		}

		return null;
	}
}
