package net.vidageek.mirror.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class MethodAnnotationHandler {

	private final Class<?> clazz;
	private final String methodName;
	private final Class<? extends Annotation> annotation;

	public MethodAnnotationHandler(Class<?> clazz, String methodName,
			Class<? extends Annotation> annotation) {
		if (clazz == null) {
			throw new IllegalArgumentException("Argument clazz cannot be null.");
		}
		if (methodName == null || methodName.trim().length() == 0) {
			throw new IllegalArgumentException(
					"Argument fieldName cannot be null or empty.");
		}
		if (annotation == null) {
			throw new IllegalArgumentException(
					"Argument annotation cannot be null.");
		}
		this.clazz = clazz;
		this.methodName = methodName.trim();
		this.annotation = annotation;
	}

	public Annotation withArgs(final Class<?>... classes) {
		Method method = new MethodReflector(methodName, clazz)
				.withArgs(classes);
		if (method == null) {
			return null;
		}
		return method.getAnnotation(annotation);
	}

	public Annotation withoutArgs() {
		Method method = new MethodReflector(methodName, clazz).withoutArgs();
		if (method == null) {
			return null;
		}
		return method.getAnnotation(annotation);
	}
}
