/**
 * 
 */
package net.vidageek.mirror.reflect;

import java.lang.reflect.Method;

import net.vidageek.mirror.Mirror;
import net.vidageek.mirror.matcher.ClassArrayMatcher;
import net.vidageek.mirror.matcher.MatchType;

/**
 * @author jonasabreu
 * 
 */
public class MethodReflector {

	private final String methodName;
	private final Class<?> clazz;

	public MethodReflector(final String methodName, final Class<?> clazz) {
		if (methodName == null || methodName.trim().length() == 0) {
			throw new IllegalArgumentException(
					"methodName cannot be null or empty");
		}
		if (clazz == null) {
			throw new IllegalArgumentException("clazz cannnot be null");
		}
		this.methodName = methodName.trim();
		this.clazz = clazz;
	}

	public Method withoutArgs() {
		return withArgs(new Class<?>[0]);
	}

	public Method withArgs(final Class<?>... classes) {
		if (classes == null) {
			throw new IllegalArgumentException("classes cannot be null");
		}
		ClassArrayMatcher matcher = new ClassArrayMatcher(classes);

		Method match = null;
		for (Method method : Mirror.on(clazz).reflectAll().methods()) {
			if (method.getName().equals(methodName)) {
				MatchType matchType = matcher.match(method.getParameterTypes());
				if (MatchType.PERFECT.equals(matchType)) {
					match = method;
					break;
				} else if (MatchType.MATCH.equals(matchType)) {
					match = method;
				}
			}
		}
		if (match != null) {
			match.setAccessible(true);
		}
		return match;
	}

}
