/**
 * 
 */
package net.vidageek.mirror.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

/**
 * @author jonasabreu
 * 
 */
public class ReflectionHandler<T> {

	private final Class<T> clazz;

	public ReflectionHandler(final Class<T> clazz) {
		if (clazz == null) {
			throw new IllegalArgumentException("clazz cannot be null");
		}
		this.clazz = clazz;
	}

	public Field field(final String fieldName) {
		if (fieldName == null || fieldName.trim().length() == 0) {
			throw new IllegalArgumentException(
					"fieldName cannot be null or empty.");
		}
		return new FieldReflector(fieldName).onClass(clazz);
	}

	public MethodReflector method(final String methodName) {
		if (methodName == null || methodName.trim().length() == 0) {
			throw new IllegalArgumentException(
					"methodName cannot be null or empty.");
		}
		return new MethodReflector(methodName, clazz);
	}

	public ConstructorReflector<T> constructor() {
		return new ConstructorReflector<T>(clazz);
	}

	public AnnotationHandler annotation(Class<? extends Annotation> annotation) {
		return new AnnotationHandler(clazz, annotation);
	}

}
