/**
 * 
 */
package net.vidageek.mirror.set;

import static net.vidageek.mirror.Mirror.on;

import java.lang.reflect.Field;

import net.vidageek.mirror.MirrorException;

/**
 * @author jonasabreu
 * 
 */
public class FieldSetterByName implements FieldSetter {

	private final String fieldName;
	private final Object target;
	private final Class<?> clazz;

	public FieldSetterByName(final String fieldName, final Object target,
			final Class<?> clazz) {
		if (fieldName == null || fieldName.trim().length() == 0) {
			throw new IllegalArgumentException(
					"fieldName cannot be null or blank");
		}

		if (clazz == null) {
			throw new IllegalArgumentException("clazz cannot be null");
		}

		this.fieldName = fieldName;
		this.target = target;
		this.clazz = clazz;
	}

	public void withValue(final Object value) {
		Field field = on(clazz).reflect().field(fieldName);
		if (field == null) {
			throw new MirrorException("could not find field " + fieldName
					+ " on class " + clazz.getName());
		}
		new FieldSetterByField(target, clazz, field).withValue(value);

	}

}
