/**
 * 
 */
package net.vidageek.mirror.set;

import java.lang.reflect.Field;

/**
 * @author jonasabreu
 * 
 */
public class SetterHandler {

	private final Object target;
	private final Class<?> clazz;

	public SetterHandler(final Object target) {
		if (target == null) {
			throw new IllegalArgumentException("target cannot be null");
		}
		this.target = target;
		clazz = target.getClass();
	}

	public SetterHandler(final Class<?> clazz) {
		if (clazz == null) {
			throw new IllegalArgumentException("clazz cannot be null");
		}
		this.clazz = clazz;
		target = null;
	}

	public FieldSetter field(final String fieldName) {
		if (fieldName == null || fieldName.trim().length() == 0) {
			throw new IllegalArgumentException(
					"fieldName cannot be null or empty.");
		}
		return new FieldSetterByName(fieldName, target, clazz);
	}

	public FieldSetter field(final Field field) {
		return new FieldSetterByField(target, clazz, field);
	}

}
