/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.provider.java;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.vidageek.mirror.exception.ReflectionProviderException;
import net.vidageek.mirror.provider.ConstructorReflectionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PureJavaConstructorReflectionProvider<T>
implements ConstructorReflectionProvider<T> {
    private final Class<T> clazz;
    private final Constructor<T> constructor;

    public PureJavaConstructorReflectionProvider(Class<T> clazz, Constructor<T> constructor) {
        this.clazz = clazz;
        this.constructor = constructor;
    }

    @Override
    public void setAccessible() {
        this.constructor.setAccessible(true);
    }

    @Override
    public T instantiate(Object ... args) {
        try {
            this.setAccessible();
            T newInstance = this.constructor.newInstance(args);
            return newInstance;
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionProviderException("could not invoke constructor " + this.constructor.toGenericString() + " on class " + this.clazz.getName(), e);
        }
        catch (InstantiationException e) {
            throw new ReflectionProviderException("could not invoke constructor " + this.constructor.toGenericString() + " on class " + this.clazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionProviderException("could not invoke constructor " + this.constructor.toGenericString() + " on class " + this.clazz.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionProviderException("could not invoke constructor " + this.constructor.toGenericString() + " on class " + this.clazz.getName(), e.getCause() == null ? e : e.getCause());
        }
    }

    @Override
    public Class<?>[] getParameters() {
        return this.constructor.getParameterTypes();
    }
}

