/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.invoke;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.vidageek.mirror.invoke.dsl.MethodHandler;
import net.vidageek.mirror.provider.MethodReflectionProvider;
import net.vidageek.mirror.provider.ReflectionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodHandlerByMethod
implements MethodHandler {
    private final Object target;
    private final Class<?> clazz;
    private final Method method;
    private final ReflectionProvider provider;

    public MethodHandlerByMethod(ReflectionProvider provider, Object target, Class<?> clazz, Method method) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("method cannot be null");
        }
        if (!method.getDeclaringClass().isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("method " + method + " cannot be invoked on clazz " + clazz.getName());
        }
        this.provider = provider;
        this.target = target;
        this.clazz = clazz;
        this.method = method;
    }

    @Override
    public Object withArgs(Object ... args) {
        if (this.target == null && !Modifier.isStatic(this.method.getModifiers())) {
            throw new IllegalStateException("attempt to call instance method " + this.method.getName() + " on class " + this.clazz.getName());
        }
        MethodReflectionProvider methodReflectionProvider = this.provider.getMethodReflectionProvider(this.target, this.clazz, this.method);
        methodReflectionProvider.setAccessible();
        return methodReflectionProvider.invoke(args);
    }

    @Override
    public Object withoutArgs() {
        return this.withArgs(new Object[0]);
    }
}

