/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.reflect;

import java.lang.reflect.Field;
import net.vidageek.mirror.provider.ReflectionProvider;
import net.vidageek.mirror.provider.java.PureJavaClassGenericTypeAccessor;
import net.vidageek.mirror.reflect.DefaultAnnotationHandler;
import net.vidageek.mirror.reflect.DefaultConstructorReflector;
import net.vidageek.mirror.reflect.DefaultFieldReflector;
import net.vidageek.mirror.reflect.DefaultMethodReflector;
import net.vidageek.mirror.reflect.DefaultParameterizedElementHandler;
import net.vidageek.mirror.reflect.dsl.AnnotationHandler;
import net.vidageek.mirror.reflect.dsl.ConstructorReflector;
import net.vidageek.mirror.reflect.dsl.MethodReflector;
import net.vidageek.mirror.reflect.dsl.ParameterizedElementHandler;
import net.vidageek.mirror.reflect.dsl.ReflectionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultReflectionHandler<T>
implements ReflectionHandler<T> {
    private final Class<T> clazz;
    private final ReflectionProvider provider;

    public DefaultReflectionHandler(ReflectionProvider provider, Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        this.provider = provider;
        this.clazz = clazz;
    }

    @Override
    public Field field(String fieldName) {
        if (fieldName == null || fieldName.trim().length() == 0) {
            throw new IllegalArgumentException("fieldName cannot be null or empty.");
        }
        return new DefaultFieldReflector(this.provider, fieldName).onClass(this.clazz);
    }

    @Override
    public MethodReflector method(String methodName) {
        if (methodName == null || methodName.trim().length() == 0) {
            throw new IllegalArgumentException("methodName cannot be null or empty.");
        }
        return new DefaultMethodReflector(this.provider, methodName, this.clazz);
    }

    @Override
    public ConstructorReflector<T> constructor() {
        return new DefaultConstructorReflector<T>(this.provider, this.clazz);
    }

    @Override
    public <A> AnnotationHandler<? extends A> annotation(Class<A> annotation) {
        return new DefaultAnnotationHandler<A>(this.provider, this.clazz, annotation);
    }

    @Override
    public ParameterizedElementHandler parentGenericType() {
        PureJavaClassGenericTypeAccessor accessor = new PureJavaClassGenericTypeAccessor(this.clazz);
        return new DefaultParameterizedElementHandler(this.provider, accessor);
    }
}

