/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.vidageek.mirror.config.Item;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.exception.MirrorException;
import net.vidageek.mirror.provider.ReflectionProvider;
import net.vidageek.mirror.provider.java.DefaultMirrorReflectionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MirrorProviderBuilder {
    private final InputStream configurationFile;

    public MirrorProviderBuilder(InputStream configurationFile) {
        this.configurationFile = configurationFile;
    }

    public ReflectionProvider createProvider() {
        if (this.configurationFile == null) {
            return new DefaultMirrorReflectionProvider();
        }
        Map<Item, String> cfg = this.processProperties(this.configurationFile);
        Mirror mirror = new Mirror(new DefaultMirrorReflectionProvider());
        return (ReflectionProvider)mirror.on(cfg.get((Object)Item.REFLECTION_PROVIDER)).invoke().constructor().withoutArgs();
    }

    private Map<Item, String> processProperties(InputStream configurationFile) {
        HashMap<Item, String> map = new HashMap<Item, String>();
        map.put(Item.REFLECTION_PROVIDER, DefaultMirrorReflectionProvider.class.getName());
        try {
            Properties properties = new Properties();
            properties.load(configurationFile);
            for (Item item : Item.values()) {
                if (!properties.containsKey(item.getPropertyKey())) continue;
                map.put(item, properties.getProperty(item.getPropertyKey()).trim());
            }
        }
        catch (IOException e) {
            throw new MirrorException("could not ready file " + configurationFile, e);
        }
        return map;
    }
}

