/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.invoke;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.exception.MirrorException;
import net.vidageek.mirror.invoke.ConstructorHandlerByConstructor;
import net.vidageek.mirror.invoke.dsl.ConstructorHandler;
import net.vidageek.mirror.provider.ConstructorBypassingReflectionProvider;
import net.vidageek.mirror.provider.ReflectionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConstructorHandlerByArgs<T>
implements ConstructorHandler<T> {
    private final Class<T> clazz;
    private final ReflectionProvider provider;

    public ConstructorHandlerByArgs(ReflectionProvider provider, Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument class cannot be null");
        }
        this.provider = provider;
        this.clazz = clazz;
    }

    @Override
    public T withoutArgs() {
        return this.withArgs(new Object[0]);
    }

    @Override
    public T withArgs(Object ... args) {
        return new ConstructorHandlerByConstructor<T>(this.provider, this.clazz, this.getConstructor(args)).withArgs(args);
    }

    @Override
    public T bypasser() {
        ConstructorBypassingReflectionProvider<T> bypassingProvider = this.provider.getConstructorBypassingReflectionProvider(this.clazz);
        return bypassingProvider.bypassConstructor();
    }

    private Constructor<T> getConstructor(Object ... args) {
        int length = args == null ? 0 : args.length;
        Class[] classes = new Class[length];
        for (int i = 0; i < length; ++i) {
            if (args[i] == null) {
                throw new IllegalArgumentException("Cannot invoke a constructor by args if one of it's arguments is null. First reflect the constructor.");
            }
            classes[i] = args[i].getClass();
        }
        Constructor<T> con = new Mirror(this.provider).on(this.clazz).reflect().constructor().withArgs(classes);
        if (con == null) {
            throw new MirrorException("Could not find constructor with args " + Arrays.asList(classes) + " on class " + this.clazz.getName());
        }
        return con;
    }
}

