/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.provider.experimental.sun15;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.exception.ReflectionProviderException;
import net.vidageek.mirror.provider.FieldReflectionProvider;
import net.vidageek.mirror.provider.java.DefaultMirrorReflectionProvider;
import sun.misc.Unsafe;
import sun.reflect.FieldAccessor;
import sun.reflect.MethodAccessor;
import sun.reflect.ReflectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Sun15FieldReflectionProvider
implements FieldReflectionProvider {
    private static final Unsafe unsafe;
    private static final long fieldAccessorFieldOffset;
    private static final MethodAccessor fieldAccessorAcquirer;
    private final FieldAccessor accessor;
    private final Object target;
    private final Field field;
    private final Class<?> clazz;
    private static final Object[] objectArray;

    public Sun15FieldReflectionProvider(Object target, Class<?> clazz, Field field) {
        this.target = target;
        this.clazz = clazz;
        this.field = field;
        FieldAccessor accessor = (FieldAccessor)unsafe.getObject(field, fieldAccessorFieldOffset);
        if (accessor == null) {
            try {
                fieldAccessorAcquirer.invoke((Object)field, objectArray);
            }
            catch (IllegalArgumentException e) {
                throw new ReflectionProviderException("Could not acquire FieldAccessor.", e);
            }
            catch (InvocationTargetException e) {
                throw new ReflectionProviderException("Could not acquire FieldAccessor.", e);
            }
            accessor = (FieldAccessor)unsafe.getObject(field, fieldAccessorFieldOffset);
        }
        this.accessor = accessor;
    }

    @Override
    public Object getValue() {
        return this.accessor.get(this.target);
    }

    @Override
    public void setValue(Object value) {
        try {
            this.accessor.set(this.target, value);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionProviderException("could not set value " + value + " on field " + this.field.getName() + " of class " + this.clazz.getName());
        }
        catch (IllegalAccessException e) {
            throw new ReflectionProviderException("could not set value " + value + " on field " + this.field.getName() + " of class " + this.clazz.getName());
        }
    }

    @Override
    public void setAccessible() {
        this.field.setAccessible(true);
    }

    static {
        objectArray = new Object[]{true};
        Mirror mirror = new Mirror(new DefaultMirrorReflectionProvider());
        Field accessor = mirror.on(Field.class).reflect().field("overrideFieldAccessor");
        Method acquirer = mirror.on(Field.class).reflect().method("acquireFieldAccessor").withArgs(Boolean.TYPE);
        unsafe = (Unsafe)mirror.on(Unsafe.class).get().field("theUnsafe");
        fieldAccessorFieldOffset = unsafe.objectFieldOffset(accessor);
        fieldAccessorAcquirer = ReflectionFactory.getReflectionFactory().newMethodAccessor(acquirer);
    }
}

