/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.provider.experimental.sun15;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.exception.ReflectionProviderException;
import net.vidageek.mirror.provider.MethodReflectionProvider;
import net.vidageek.mirror.provider.java.DefaultMirrorReflectionProvider;
import net.vidageek.mirror.provider.java.PureJavaMethodReflectionProvider;
import sun.misc.Unsafe;
import sun.reflect.MethodAccessor;
import sun.reflect.ReflectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Sun15MethodReflectionProvider
implements MethodReflectionProvider {
    private final Object target;
    private final Method method;
    private final MethodAccessor accessor;
    private static final long methodAccessorFieldOffset;
    private static final Unsafe unsafe;
    private static final MethodAccessor methodAccessorAcquirer;
    private static final Object[] emptyObjectArray;
    private final Class<?> clazz;

    public Sun15MethodReflectionProvider(Object target, Class<?> clazz, Method method) {
        this.target = target;
        this.clazz = clazz;
        this.method = method;
        MethodAccessor accessor = (MethodAccessor)unsafe.getObject(method, methodAccessorFieldOffset);
        if (accessor == null) {
            try {
                methodAccessorAcquirer.invoke((Object)method, emptyObjectArray);
            }
            catch (IllegalArgumentException e) {
                throw new ReflectionProviderException("Could not acquire MethodAccessor.", e);
            }
            catch (InvocationTargetException e) {
                throw new ReflectionProviderException("Could not acquire MethodAccessor.", e);
            }
            accessor = (MethodAccessor)unsafe.getObject(method, methodAccessorFieldOffset);
        }
        this.accessor = accessor;
    }

    @Override
    public Class<?>[] getParameters() {
        return new PureJavaMethodReflectionProvider(this.target, this.clazz, this.method).getParameters();
    }

    @Override
    public Object invoke(Object[] args) {
        try {
            return this.accessor.invoke(this.target, args);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionProviderException("Could not invoke method " + this.method.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionProviderException("Could not invoke method " + this.method.getName(), e);
        }
        catch (NullPointerException e) {
            throw new ReflectionProviderException("Attempt to call an instance method ( " + this.method.getName() + ") on a null object.", e);
        }
    }

    @Override
    public void setAccessible() {
        this.method.setAccessible(true);
    }

    static {
        emptyObjectArray = new Object[0];
        Mirror mirror = new Mirror(new DefaultMirrorReflectionProvider());
        Field accessor = mirror.on(Method.class).reflect().field("methodAccessor");
        Method acquirer = mirror.on(Method.class).reflect().method("acquireMethodAccessor").withoutArgs();
        unsafe = (Unsafe)mirror.on(Unsafe.class).get().field("theUnsafe");
        methodAccessorFieldOffset = unsafe.objectFieldOffset(accessor);
        methodAccessorAcquirer = ReflectionFactory.getReflectionFactory().newMethodAccessor(acquirer);
    }
}

