/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.reflect;

import java.lang.annotation.Annotation;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.provider.ReflectionProvider;
import net.vidageek.mirror.reflect.DefaultMethodAnnotationHandler;
import net.vidageek.mirror.reflect.dsl.AnnotationHandler;
import net.vidageek.mirror.reflect.dsl.MethodAnnotationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultAnnotationHandler<T extends Annotation>
implements AnnotationHandler<T> {
    private final Class<?> clazz;
    private final Class<T> annotation;
    private final ReflectionProvider provider;

    public DefaultAnnotationHandler(ReflectionProvider provider, Class<?> clazz, Class<T> annotation) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument clazz cannot be null.");
        }
        if (annotation == null) {
            throw new IllegalArgumentException("Argument annotation cannot be null.");
        }
        this.provider = provider;
        this.clazz = clazz;
        this.annotation = annotation;
    }

    @Override
    public T atField(String fieldName) {
        if (fieldName == null || fieldName.trim().length() == 0) {
            throw new IllegalArgumentException("fieldName cannot be null or empty.");
        }
        return this.provider.getAnnotatedElementReflectionProvider(new Mirror(this.provider).on(this.clazz).reflect().field(fieldName)).getAnnotation(this.annotation);
    }

    @Override
    public MethodAnnotationHandler<T> atMethod(String methodName) {
        if (methodName == null || methodName.trim().length() == 0) {
            throw new IllegalArgumentException("methodName cannot be null or empty");
        }
        return new DefaultMethodAnnotationHandler<T>(this.provider, this.clazz, methodName, this.annotation);
    }

    @Override
    public T atClass() {
        return this.provider.getAnnotatedElementReflectionProvider(this.clazz).getAnnotation(this.annotation);
    }
}

