/*
 * Decompiled with CFR 0.152.
 */
package net.vivialconnect.client;

import java.net.Proxy;

public final class VivialConnectClient {
    private static int accountId;
    private static String apiKey;
    private static String apiSecret;
    private static String apiBaseUrl;
    private static Proxy proxy;

    private VivialConnectClient() {
    }

    public static String getApiKey() {
        return apiKey;
    }

    public static String getApiSecret() {
        return apiSecret;
    }

    public static int getAccountId() {
        return accountId;
    }

    public static String getApiBaseUrl() {
        return apiBaseUrl;
    }

    public static void overrideApiBaseUrl(String apiBaseUrl) {
        VivialConnectClient.apiBaseUrl = apiBaseUrl;
    }

    public static void init(int accountId, String apiKey, String apiSecret) {
        VivialConnectClient.validateInitialArguments(accountId, apiKey, apiSecret);
        VivialConnectClient.accountId = accountId;
        VivialConnectClient.apiKey = apiKey;
        VivialConnectClient.apiSecret = apiSecret;
    }

    private static void validateInitialArguments(int accountId, String apiKey, String apiSecret) {
        VivialConnectClient.validateAccountId(accountId);
        VivialConnectClient.validateAPIKey(apiKey);
        VivialConnectClient.validateAPISecret(apiSecret);
    }

    private static void validateAccountId(int accountId) {
        if (accountId < 1) {
            throw VivialConnectClient.createIllegalArgumentException("accountId");
        }
    }

    private static void validateAPIKey(String apiKey) {
        VivialConnectClient.validateStringArg(apiKey, "apiKey");
    }

    private static void validateAPISecret(String apiSecret) {
        VivialConnectClient.validateStringArg(apiSecret, "apiSecret");
    }

    private static void validateStringArg(String arg, String argName) {
        if (arg == null || arg.isEmpty()) {
            throw VivialConnectClient.createIllegalArgumentException(argName);
        }
    }

    private static IllegalArgumentException createIllegalArgumentException(String argName) {
        return new IllegalArgumentException(String.format("'%s' param is not valid", argName));
    }

    public static void setProxy(Proxy proxy) {
        VivialConnectClient.proxy = proxy;
    }

    public static Proxy getProxy() {
        return proxy;
    }

    static {
        apiBaseUrl = "https://api.vivialconnect.net/api/v1.0";
        proxy = null;
    }
}

