/*
 * Decompiled with CFR 0.152.
 */
package net.vivialconnect.http;

import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;

public class RequestBuilder {
    private WebResource resource;
    private Object entity;
    private MediaType type = null;
    private List<MediaType> accept = new ArrayList<MediaType>();
    private MultivaluedMap<String, String> queryParams;
    private MultivaluedMap<String, String> formData;
    private Map<String, Object> headers;
    private List<Cookie> cookies;

    public RequestBuilder(WebResource resource) {
        this.resource = resource;
    }

    public RequestBuilder path(String path) {
        this.resource = this.resource.path(path);
        return this;
    }

    public RequestBuilder queryParam(String name, String value) {
        if (value != null) {
            this.queryParams().add((Object)name, (Object)value);
        }
        return this;
    }

    public RequestBuilder queryParam(String name, Integer intValue) {
        if (intValue != null) {
            String value = "" + intValue;
            this.queryParams().add((Object)name, (Object)value);
        }
        return this;
    }

    public RequestBuilder queryParam(String name, Long longValue) {
        if (longValue != null) {
            String value = "" + longValue;
            this.queryParams().add((Object)name, (Object)value);
        }
        return this;
    }

    public RequestBuilder queryParam(String name, Boolean value) {
        if (value != null) {
            this.queryParams().add((Object)name, (Object)value.toString());
        }
        return this;
    }

    public RequestBuilder queryParam(String name, Collection<?> values) {
        if (values != null && values.size() > 0) {
            if (this.queryParams == null) {
                this.queryParams = new MultivaluedMapImpl();
            }
            for (Object value : values) {
                this.queryParams.add((Object)name, (Object)value.toString());
            }
        }
        return this;
    }

    public RequestBuilder formData(String name, String value) {
        if (value != null) {
            this.formData().add((Object)name, (Object)value);
        }
        return this;
    }

    public RequestBuilder formData(String name, Integer intValue) {
        if (intValue != null) {
            String value = "" + intValue;
            this.formData().add((Object)name, (Object)value);
        }
        return this;
    }

    public RequestBuilder formData(String name, Long longValue) {
        if (longValue != null) {
            String value = "" + longValue;
            this.formData().add((Object)name, (Object)value);
        }
        return this;
    }

    public RequestBuilder formData(String name, Boolean value) {
        if (value != null) {
            this.formData().add((Object)name, (Object)value.toString());
        }
        return this;
    }

    public RequestBuilder formData(String name, Collection<?> values) {
        if (values != null && values.size() > 0) {
            if (this.formData == null) {
                this.formData = new MultivaluedMapImpl();
            }
            for (Object value : values) {
                this.formData.add((Object)name, (Object)value.toString());
            }
        }
        return this;
    }

    public RequestBuilder entity(Object _entity) {
        this.entity = _entity;
        return this;
    }

    public RequestBuilder entity(Object _entity, MediaType _type) {
        this.entity(_entity);
        this.type(_type);
        return this;
    }

    public RequestBuilder entity(Object _entity, String _type) {
        this.entity(_entity);
        this.type(_type);
        return this;
    }

    public RequestBuilder type(MediaType _type) {
        this.type = _type;
        return this;
    }

    public RequestBuilder type(String _type) {
        this.type = MediaType.valueOf((String)_type);
        return this;
    }

    public RequestBuilder accept(MediaType ... types) {
        for (MediaType t : types) {
            this.accept.add(t);
        }
        return this;
    }

    public RequestBuilder accept(String ... types) {
        for (String t : types) {
            this.accept.add(MediaType.valueOf((String)t));
        }
        return this;
    }

    public RequestBuilder cookie(Cookie cookie) {
        if (this.cookies == null) {
            this.cookies = new ArrayList<Cookie>();
        }
        this.cookies.add(cookie);
        return this;
    }

    public RequestBuilder header(String name, Object Value) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, Object>();
        }
        this.headers.put(name, Value);
        return this;
    }

    public <T> T options(Class<T> c) throws Exception {
        return this.handle(c, "OPTIONS");
    }

    public <T> T get(Class<T> c) throws Exception {
        return this.handle(c, "GET");
    }

    public <T> T getNoThrow(Class<T> c) {
        try {
            return this.handle(c, "GET");
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    public void put() throws Exception {
        this.voidHandle("PUT");
    }

    public void put(Object requestEntity) throws Exception {
        this.entity(requestEntity);
        this.voidHandle("PUT");
    }

    public <T> T put(Class<T> c) throws Exception {
        return this.handle(c, "PUT");
    }

    public <T> T put(Class<T> c, Object requestEntity) throws Exception {
        this.entity(requestEntity);
        return this.handle(c, "PUT");
    }

    public void post() throws Exception {
        this.voidHandle("POST");
    }

    public void post(Object requestEntity) throws Exception {
        this.entity(requestEntity);
        this.voidHandle("POST");
    }

    public <T> T post(Class<T> c) throws Exception {
        if (this.formData != null) {
            this.entity(this.formData);
        }
        return this.handle(c, "POST");
    }

    public <T> T post(Class<T> c, Object requestEntity) throws Exception {
        this.entity(requestEntity);
        return this.handle(c, "POST");
    }

    public void delete() throws Exception {
        this.voidHandle("DELETE");
    }

    public <T> T delete(Class<T> c) throws Exception {
        return this.handle(c, "DELETE");
    }

    private <T> T handle(Class<T> c, String method) throws Exception {
        try {
            return (T)this.generateBuilder().method(method, c);
        }
        catch (UniformInterfaceException uie) {
            throw new Exception(uie);
        }
    }

    private void voidHandle(String method) throws Exception {
        try {
            this.generateBuilder().method(method);
        }
        catch (UniformInterfaceException uie) {
            throw new Exception(uie);
        }
    }

    private WebResource.Builder generateBuilder() throws Exception {
        WebResource r = this.resource;
        if (this.queryParams != null) {
            r = r.queryParams(this.queryParams);
        }
        WebResource.Builder builder = r.getRequestBuilder();
        if (this.entity != null) {
            builder.entity(this.entity);
        }
        if (this.type != null) {
            builder.type(this.type);
        }
        if (this.accept != null && this.accept.size() > 0) {
            MediaType[] types = new MediaType[this.accept.size()];
            for (int i = 0; i < types.length; ++i) {
                types[i] = this.accept.get(i);
            }
            builder.accept(types);
        } else {
            builder.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        }
        if (this.headers != null) {
            for (Map.Entry<String, Object> header : this.headers.entrySet()) {
                builder.header(header.getKey(), header.getValue());
            }
        }
        if (this.cookies != null) {
            for (Cookie cookie : this.cookies) {
                builder.cookie(cookie);
            }
        }
        return builder;
    }

    private MultivaluedMap<String, String> queryParams() {
        if (this.queryParams == null) {
            this.queryParams = new MultivaluedMapImpl();
        }
        return this.queryParams;
    }

    private MultivaluedMap<String, String> formData() {
        if (this.formData == null) {
            this.formData = new MultivaluedMapImpl();
        }
        return this.formData;
    }
}

