/*
 * Decompiled with CFR 0.152.
 */
package net.vivialconnect.model.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.Date;
import java.util.List;
import net.vivialconnect.model.VivialConnectResource;
import net.vivialconnect.model.account.Contact;
import net.vivialconnect.model.account.ContactCollection;
import net.vivialconnect.model.account.Service;
import net.vivialconnect.model.error.VivialConnectException;
import net.vivialconnect.model.format.JsonBodyBuilder;
import net.vivialconnect.model.log.LogCollection;

@JsonRootName(value="account")
public class Account
extends VivialConnectResource {
    private static final long serialVersionUID = -2624039897600671223L;
    @JsonProperty
    private int id;
    @JsonProperty(value="date_created")
    private Date dateCreated;
    @JsonProperty(value="date_modified")
    private Date dateModified;
    @JsonProperty(value="account_id")
    private int accountId;
    @JsonProperty(value="company_name")
    private String companyName;
    @JsonProperty
    private boolean active;
    @JsonProperty
    private List<Contact> contacts;
    @JsonProperty
    private List<Service> services;

    public static Account getAccount() throws VivialConnectException {
        return Account.request(VivialConnectResource.RequestMethod.GET, Account.singleClassURL(Account.class), null, null, Account.class);
    }

    public Account update() throws VivialConnectException {
        Account updatedAccount = Account.request(VivialConnectResource.RequestMethod.PUT, Account.singleClassURL(Account.class), this.buildJsonBodyForUpdate(), null, Account.class);
        this.updateFields(updatedAccount);
        return this;
    }

    private String buildJsonBodyForUpdate() {
        JsonBodyBuilder builder = JsonBodyBuilder.forClass(Account.class);
        this.fillOptionalFieldsForUpdate(builder);
        return builder.build();
    }

    private void fillOptionalFieldsForUpdate(JsonBodyBuilder builder) {
        Account.ifParamValidAddToBuilder(builder, "id", this.getId());
        Account.ifParamValidAddToBuilder(builder, "company_name", this.getCompanyName());
    }

    private void updateFields(Account updatedAccount) {
        this.id = updatedAccount.getId();
        this.accountId = updatedAccount.getAccountId();
        this.active = updatedAccount.isActive();
        this.companyName = updatedAccount.getCompanyName();
        this.dateCreated = updatedAccount.getDateCreated();
        this.dateModified = updatedAccount.getDateModified();
        this.contacts = updatedAccount.getContacts();
        this.services = updatedAccount.getServices();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public void setAccountId(int accountId) {
        this.accountId = accountId;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public List<Contact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<Contact> contacts) {
        this.contacts = contacts;
    }

    public List<Service> getServices() {
        return this.services;
    }

    public void setServices(List<Service> services) {
        this.services = services;
    }

    static {
        classesWithoutRootValue.add(LogCollection.class);
        classesWithoutRootValue.add(ContactCollection.class);
    }
}

