/*
 * Decompiled with CFR 0.152.
 */
package net.vivialconnect.model.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.vivialconnect.model.ResourceCount;
import net.vivialconnect.model.VivialConnectResource;
import net.vivialconnect.model.account.ContactCollection;
import net.vivialconnect.model.error.NoContentException;
import net.vivialconnect.model.error.VivialConnectException;
import net.vivialconnect.model.format.JsonBodyBuilder;

@JsonRootName(value="contact")
public class Contact
extends VivialConnectResource {
    private static final long serialVersionUID = 3140451099385557777L;
    private static String[] REQUIRED_FIELDS = new String[]{"firstName", "lastName", "email", "contactType"};
    @JsonProperty
    private int id;
    @JsonProperty(value="date_created")
    private Date dateCreated;
    @JsonProperty(value="date_modified")
    private Date dateModified;
    @JsonProperty(value="account_id")
    private int accountId;
    @JsonProperty
    private boolean active;
    @JsonProperty
    private String address1;
    @JsonProperty
    private String address2;
    @JsonProperty
    private String address3;
    @JsonProperty
    private String city;
    @JsonProperty(value="company_name")
    private String companyName;
    @JsonProperty(value="contact_type")
    private String contactType;
    @JsonProperty
    private String country;
    @JsonProperty
    private String email;
    @JsonProperty
    private String fax;
    @JsonProperty(value="first_name")
    private String firstName;
    @JsonProperty(value="last_name")
    private String lastName;
    @JsonProperty(value="mobile_phone")
    private String mobilePhone;
    @JsonProperty(value="postal_code")
    private String postalCode;
    @JsonProperty
    private String state;
    @JsonProperty
    private String title;
    @JsonProperty(value="work_phone")
    private String workPhone;
    private JsonBodyBuilder jsonBodyBuilder;

    public Contact() {
        this.jsonBodyBuilder = JsonBodyBuilder.forClass(Contact.class);
    }

    public Contact(Contact contact) {
        this.jsonBodyBuilder = JsonBodyBuilder.forClass(Contact.class).addParamPair("id", contact.getId());
        this.updateObjectState(contact);
    }

    public Contact create() throws VivialConnectException {
        this.verifyRequiredFields();
        Contact createdContact = Contact.request(VivialConnectResource.RequestMethod.POST, Contact.classURL(Contact.class), this.jsonBodyForCreate(), null, Contact.class);
        this.updateObjectState(createdContact);
        return this;
    }

    private void verifyRequiredFields() {
        Class<?> c = this.getClass();
        for (int i = 0; i < REQUIRED_FIELDS.length; ++i) {
            String requiredFieldName = REQUIRED_FIELDS[i];
            Field requiredField = this.getDeclaredField(c, requiredFieldName);
            if (requiredField == null || !requiredField.getType().equals(String.class)) continue;
            String fieldValue = (String)this.getValueFromField(requiredField);
            this.validateStringValue(requiredField.getName(), fieldValue);
        }
    }

    private Field getDeclaredField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    private Object getValueFromField(Field field) {
        try {
            return field.get(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    private void validateStringValue(String fieldName, String fieldValue) {
        if (fieldValue == null || fieldValue.isEmpty()) {
            throw new IllegalStateException(String.format("Parameter '%s' is null or empty", fieldName));
        }
    }

    private String jsonBodyForCreate() {
        JsonBodyBuilder builder = JsonBodyBuilder.forClass(Contact.class);
        this.addRequiredFields(builder);
        this.addOptionalFields(builder);
        return builder.build();
    }

    private void addRequiredFields(JsonBodyBuilder builder) {
        Contact.ifParamValidAddToBuilder(builder, "first_name", this.getFirstName());
        Contact.ifParamValidAddToBuilder(builder, "last_name", this.getLastName());
        Contact.ifParamValidAddToBuilder(builder, "email", this.getEmail());
        Contact.ifParamValidAddToBuilder(builder, "contact_type", this.getContactType());
    }

    private void addOptionalFields(JsonBodyBuilder builder) {
        Contact.ifParamValidAddToBuilder(builder, "company_name", this.getCompanyName());
        Contact.ifParamValidAddToBuilder(builder, "title", this.getTitle());
        Contact.ifParamValidAddToBuilder(builder, "address1", this.getAddress1());
        Contact.ifParamValidAddToBuilder(builder, "address2", this.getAddress2());
        Contact.ifParamValidAddToBuilder(builder, "address3", this.getAddress3());
        Contact.ifParamValidAddToBuilder(builder, "city", this.getCity());
        Contact.ifParamValidAddToBuilder(builder, "state", this.getState());
        Contact.ifParamValidAddToBuilder(builder, "postal_code", this.getPostalCode());
        Contact.ifParamValidAddToBuilder(builder, "country", this.getState());
        Contact.ifParamValidAddToBuilder(builder, "mobile_phone", this.getMobilePhone());
        Contact.ifParamValidAddToBuilder(builder, "work_phone", this.getWorkPhone());
    }

    private void updateObjectState(Contact contact) {
        this.id = contact.getId();
        this.accountId = contact.getAccountId();
        this.active = contact.isActive();
        this.address1 = contact.getAddress1();
        this.address2 = contact.getAddress2();
        this.address3 = contact.getAddress3();
        this.city = contact.getCity();
        this.companyName = contact.getCompanyName();
        this.contactType = contact.getContactType();
        this.country = contact.getCountry();
        this.dateCreated = contact.getDateCreated();
        this.dateModified = contact.getDateModified();
        this.email = contact.getEmail();
        this.fax = contact.getFax();
        this.firstName = contact.getFirstName();
        this.lastName = contact.getLastName();
        this.mobilePhone = contact.getMobilePhone();
        this.postalCode = contact.getPostalCode();
        this.state = contact.getState();
        this.title = contact.getTitle();
        this.workPhone = contact.getWorkPhone();
        Contact.ifParamValidAddToBuilder(this.jsonBodyBuilder, "id", this.getId());
    }

    public Contact update() throws VivialConnectException {
        this.verifyRequiredFields();
        Contact updatedContact = Contact.request(VivialConnectResource.RequestMethod.PUT, Contact.classURLWithSuffix(Contact.class, String.valueOf(this.getId())), this.jsonBodyForUpdate(), null, Contact.class);
        this.updateObjectState(updatedContact);
        return this;
    }

    public String jsonBodyForUpdate() {
        return this.jsonBodyBuilder.build();
    }

    public boolean delete() throws VivialConnectException {
        try {
            Contact.request(VivialConnectResource.RequestMethod.DELETE, Contact.classURLWithSuffix(Contact.class, String.valueOf(this.getId())), null, null, String.class);
        }
        catch (NoContentException nce) {
            return true;
        }
        return false;
    }

    public static List<Contact> getContacts() throws VivialConnectException {
        return Contact.getContacts(null);
    }

    public static List<Contact> getContacts(Map<String, String> queryParams) throws VivialConnectException {
        return Contact.request(VivialConnectResource.RequestMethod.GET, Contact.classURL(Contact.class), null, queryParams, ContactCollection.class).getContacts();
    }

    public static Contact getContactById(int contactId) throws VivialConnectException {
        return new Contact(Contact.request(VivialConnectResource.RequestMethod.GET, Contact.classURLWithSuffix(Contact.class, String.valueOf(contactId)), null, null, Contact.class));
    }

    public static int count() throws VivialConnectException {
        return Contact.request(VivialConnectResource.RequestMethod.GET, Contact.classURLWithSuffix(Contact.class, "count"), null, null, ResourceCount.class).getCount();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
        Contact.ifParamValidAddToBuilder(this.jsonBodyBuilder, "id", this.getId());
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public void setAccountId(int accountId) {
        this.accountId = accountId;
        Contact.ifParamValidAddToBuilder(this.jsonBodyBuilder, "account_id", this.getAccountId());
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.jsonBodyBuilder.addParamPair("active", this.isActive());
    }

    public String getAddress1() {
        return this.address1;
    }

    public void setAddress1(String address1) {
        this.address1 = address1;
        Contact.ifParamValidAddToBuilder(this.jsonBodyBuilder, "address1", this.getAddress1());
    }

    public String getAddress2() {
        return this.address2;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
        Contact.ifParamValidAddToBuilder(this.jsonBodyBuilder, "address2", this.getAddress2());
    }

    public String getAddress3() {
        return this.address3;
    }

    public void setAddress3(String address3) {
        this.address3 = address3;
        Contact.ifParamValidAddToBuilder(this.jsonBodyBuilder, "address3", this.getAddress3());
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
        Contact.ifParamValidAddToBuilder(this.jsonBodyBuilder, "city", this.getCity());
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
        Contact.ifParamValidAddToBuilder(this.jsonBodyBuilder, "company_name", this.getCompanyName());
    }

    public String getContactType() {
        return this.contactType;
    }

    public void setContactType(String contactType) {
        this.contactType = contactType;
        Contact.ifParamValidAddToBuilder(this.jsonBodyBuilder, "contact_type", this.getContactType());
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
        Contact.ifParamValidAddToBuilder(this.jsonBodyBuilder, "country", this.getCountry());
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
        Contact.ifParamValidAddToBuilder(this.jsonBodyBuilder, "email", this.getEmail());
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
        Contact.ifParamValidAddToBuilder(this.jsonBodyBuilder, "fax", this.getFax());
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
        Contact.ifParamValidAddToBuilder(this.jsonBodyBuilder, "first_name", this.getFirstName());
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
        Contact.ifParamValidAddToBuilder(this.jsonBodyBuilder, "last_name", this.getLastName());
    }

    public String getMobilePhone() {
        return this.mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
        Contact.ifParamValidAddToBuilder(this.jsonBodyBuilder, "mobile_phone", this.getMobilePhone());
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
        Contact.ifParamValidAddToBuilder(this.jsonBodyBuilder, "postal_code", this.getPostalCode());
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
        Contact.ifParamValidAddToBuilder(this.jsonBodyBuilder, "state", this.getState());
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        Contact.ifParamValidAddToBuilder(this.jsonBodyBuilder, "title", this.getTitle());
    }

    public String getWorkPhone() {
        return this.workPhone;
    }

    public void setWorkPhone(String workPhone) {
        this.workPhone = workPhone;
        Contact.ifParamValidAddToBuilder(this.jsonBodyBuilder, "work_phone", this.getWorkPhone());
    }

    static {
        classesWithoutRootValue.add(ContactCollection.class);
    }
}

