/*
 * Decompiled with CFR 0.152.
 */
package net.vivialconnect.model.connector;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.vivialconnect.model.ResourceCount;
import net.vivialconnect.model.VivialConnectResource;
import net.vivialconnect.model.connector.Callback;
import net.vivialconnect.model.connector.ConnectorCollection;
import net.vivialconnect.model.connector.ConnectorWithCallbacks;
import net.vivialconnect.model.connector.ConnectorWithPhoneNumbers;
import net.vivialconnect.model.connector.PhoneNumber;
import net.vivialconnect.model.error.NoContentException;
import net.vivialconnect.model.error.VivialConnectException;
import net.vivialconnect.model.format.JsonBodyBuilder;

@JsonRootName(value="connector")
public class Connector
extends VivialConnectResource
implements ConnectorWithCallbacks,
ConnectorWithPhoneNumbers {
    private static final long serialVersionUID = 9106799578930523035L;
    @JsonProperty
    private int id;
    @JsonProperty(value="date_created")
    private Date dateCreated;
    @JsonProperty(value="date_modified")
    private Date dateModified;
    @JsonProperty(value="account_id")
    private int accountId;
    @JsonProperty
    private boolean active;
    @JsonProperty
    private String name;
    @JsonProperty
    private List<Callback> callbacks;
    @JsonProperty(value="phone_numbers")
    private List<PhoneNumber> phoneNumbers;
    @JsonProperty(value="more_numbers")
    private boolean moreNumbers;

    public static Connector getConnectorById(int connectorId) throws VivialConnectException {
        return Connector.request(VivialConnectResource.RequestMethod.GET, Connector.classURLWithSuffix(Connector.class, String.valueOf(connectorId)), null, null, Connector.class);
    }

    public static List<Connector> getConnectors() throws VivialConnectException {
        return Connector.request(VivialConnectResource.RequestMethod.GET, Connector.classURL(Connector.class), null, null, ConnectorCollection.class).getConnectors();
    }

    public static int count() throws VivialConnectException {
        return Connector.request(VivialConnectResource.RequestMethod.GET, Connector.classURLWithSuffix(Connector.class, "count"), null, null, ResourceCount.class).getCount();
    }

    public Connector create() throws VivialConnectException {
        JsonBodyBuilder builder = JsonBodyBuilder.forClass(Connector.class).addParamPair("name", this.getName());
        Connector createdConnector = Connector.request(VivialConnectResource.RequestMethod.POST, Connector.classURL(Connector.class), builder.build(), null, Connector.class);
        this.updateObjectState(createdConnector);
        return this;
    }

    public Connector update() throws VivialConnectException {
        JsonBodyBuilder builder = JsonBodyBuilder.forClass(Connector.class).addParamPair("id", this.getId()).addParamPair("name", this.getName());
        Connector updatedConnector = Connector.request(VivialConnectResource.RequestMethod.PUT, Connector.classURLWithSuffix(Connector.class, String.valueOf(this.getId())), builder.build(), null, Connector.class);
        this.updateObjectState(updatedConnector);
        return this;
    }

    private void updateObjectState(Connector connector) {
        this.id = connector.getId();
        this.dateCreated = connector.getDateCreated();
        this.dateModified = connector.getDateModified();
        this.accountId = connector.getAccountId();
        this.active = connector.isActive();
        this.callbacks = connector.getCallbacks();
        this.name = connector.getName();
        this.phoneNumbers = connector.getPhoneNumbers();
        this.moreNumbers = connector.isMoreNumbers();
    }

    public boolean delete() throws VivialConnectException {
        try {
            Connector.request(VivialConnectResource.RequestMethod.DELETE, Connector.classURLWithSuffix(Connector.class, String.valueOf(this.getId())), null, null, String.class);
        }
        catch (NoContentException nce) {
            return true;
        }
        return false;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Override
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public void setAccountId(int accountId) {
        this.accountId = accountId;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<Callback> getCallbacks() {
        return this.callbacks;
    }

    public void setCallbacks(List<Callback> callbacks) {
        this.callbacks = callbacks;
    }

    public Connector addCallback(Callback callback) {
        if (this.callbacks == null) {
            this.callbacks = new ArrayList<Callback>();
        }
        this.callbacks.add(callback);
        return this;
    }

    public ConnectorWithCallbacks createCallbacks() throws VivialConnectException {
        JsonBodyBuilder builder = JsonBodyBuilder.forClass(Connector.class).addParamPair("callbacks", this.callbacks);
        Connector connectorWithCallbacks = Connector.request(VivialConnectResource.RequestMethod.POST, Connector.classURLWithSuffix(Connector.class, String.format("%d/callbacks", this.getId())), builder.build(), null, Connector.class);
        this.mergeCallbackFields(connectorWithCallbacks);
        return this;
    }

    public ConnectorWithCallbacks updateCallbacks() throws VivialConnectException {
        JsonBodyBuilder builder = JsonBodyBuilder.forClass(Connector.class).addParamPair("callbacks", this.callbacks);
        Connector connectorWithCallbacks = Connector.request(VivialConnectResource.RequestMethod.PUT, Connector.classURLWithSuffix(Connector.class, String.format("%d/callbacks", this.getId())), builder.build(), null, Connector.class);
        this.mergeCallbackFields(connectorWithCallbacks);
        return this;
    }

    private void mergeCallbackFields(ConnectorWithCallbacks connectorWithCallbacks) {
        this.dateModified = connectorWithCallbacks.getDateModified();
        this.callbacks = connectorWithCallbacks.getCallbacks();
    }

    public ConnectorWithCallbacks deleteAllCallbacks() throws VivialConnectException {
        return this.deleteCallbacks(this.callbacks);
    }

    public ConnectorWithCallbacks deleteSingleCallback(Callback callback) throws VivialConnectException {
        ArrayList<Callback> singleCallbackList = new ArrayList<Callback>(1);
        singleCallbackList.add(callback);
        return this.deleteCallbacks(singleCallbackList);
    }

    public ConnectorWithCallbacks deleteCallbacks(List<Callback> callbacks) throws VivialConnectException {
        JsonBodyBuilder builder = JsonBodyBuilder.forClass(Connector.class).addParamPair("callbacks", callbacks);
        return Connector.request(VivialConnectResource.RequestMethod.DELETE, Connector.classURLWithSuffix(Connector.class, String.format("%d/callbacks", this.getId())), builder.build(), null, Connector.class);
    }

    @Override
    public List<PhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(List<PhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public Connector addPhoneNumber(int phoneNumberId, String phoneNumber) {
        return this.addPhoneNumber(new PhoneNumber(phoneNumberId, phoneNumber));
    }

    public Connector addPhoneNumber(PhoneNumber phoneNumber) {
        if (this.phoneNumbers == null) {
            this.phoneNumbers = new ArrayList<PhoneNumber>();
        }
        this.phoneNumbers.add(phoneNumber);
        return this;
    }

    public ConnectorWithPhoneNumbers associatePhoneNumbers() throws VivialConnectException {
        JsonBodyBuilder builder = JsonBodyBuilder.forClass(Connector.class).addParamPair("phone_numbers", this.phoneNumbers);
        Connector connectorWithPhoneNumbers = Connector.request(VivialConnectResource.RequestMethod.POST, Connector.classURLWithSuffix(Connector.class, String.format("%d/phone_numbers", this.getId())), builder.build(), null, Connector.class);
        this.mergePhoneNumberFields(connectorWithPhoneNumbers);
        return this;
    }

    public ConnectorWithPhoneNumbers updateAssociatedPhoneNumbers() throws VivialConnectException {
        JsonBodyBuilder builder = JsonBodyBuilder.forClass(Connector.class).addParamPair("phone_numbers", this.phoneNumbers);
        Connector connectorWithPhoneNumbers = Connector.request(VivialConnectResource.RequestMethod.PUT, Connector.classURLWithSuffix(Connector.class, String.format("%d/phone_numbers", this.getId())), builder.build(), null, Connector.class);
        this.mergePhoneNumberFields(connectorWithPhoneNumbers);
        return this;
    }

    public ConnectorWithPhoneNumbers deleteAllPhoneNumbers() throws VivialConnectException {
        return this.deletePhoneNumbers(this.phoneNumbers);
    }

    public ConnectorWithPhoneNumbers deleteSinglePhoneNumber(PhoneNumber phoneNumber) throws VivialConnectException {
        ArrayList<PhoneNumber> singlePhoneNumberList = new ArrayList<PhoneNumber>(1);
        singlePhoneNumberList.add(phoneNumber);
        return this.deletePhoneNumbers(singlePhoneNumberList);
    }

    public ConnectorWithPhoneNumbers deletePhoneNumbers(List<PhoneNumber> phoneNumbers) throws VivialConnectException {
        JsonBodyBuilder builder = JsonBodyBuilder.forClass(Connector.class).addParamPair("phone_numbers", phoneNumbers);
        return Connector.request(VivialConnectResource.RequestMethod.DELETE, Connector.classURLWithSuffix(Connector.class, String.format("%d/phone_numbers", this.getId())), builder.build(), null, Connector.class);
    }

    private void mergePhoneNumberFields(ConnectorWithPhoneNumbers connectorWithPhoneNumbers) {
        this.dateModified = connectorWithPhoneNumbers.getDateModified();
        this.phoneNumbers = connectorWithPhoneNumbers.getPhoneNumbers();
    }

    public boolean isMoreNumbers() {
        return this.moreNumbers;
    }

    public void setMoreNumbers(boolean moreNumbers) {
        this.moreNumbers = moreNumbers;
    }

    static {
        classesWithoutRootValue.add(ConnectorCollection.class);
    }
}

