/*
 * Decompiled with CFR 0.152.
 */
package net.vivialconnect.model.connector;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import net.vivialconnect.model.ResourceCount;
import net.vivialconnect.model.VivialConnectResource;
import net.vivialconnect.model.connector.Connector;
import net.vivialconnect.model.connector.ConnectorWithPhoneNumbers;
import net.vivialconnect.model.error.VivialConnectException;

@JsonRootName(value="phone_number")
public class PhoneNumber
extends VivialConnectResource {
    private static final long serialVersionUID = -621133784366767246L;
    @JsonProperty(value="phone_number")
    private String phoneNumber;
    @JsonProperty(value="phone_number_id")
    private int phoneNumberId;

    public PhoneNumber() {
    }

    public PhoneNumber(int phoneNumberId, String phoneNumber) {
        this.phoneNumberId = phoneNumberId;
        this.phoneNumber = phoneNumber;
    }

    public static ConnectorWithPhoneNumbers getPhoneNumbers(int connectorId) throws VivialConnectException {
        return PhoneNumber.request(VivialConnectResource.RequestMethod.GET, PhoneNumber.classURLWithSuffix(Connector.class, String.format("%d/phone_numbers", connectorId)), null, null, Connector.class);
    }

    public static int count(int connectorId) throws VivialConnectException {
        return PhoneNumber.request(VivialConnectResource.RequestMethod.GET, PhoneNumber.classURLWithSuffix(Connector.class, String.format("%d/phone_numbers/count", connectorId)), null, null, ResourceCount.class).getCount();
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public int getPhoneNumberId() {
        return this.phoneNumberId;
    }

    public void setPhoneNumberId(int phoneNumberId) {
        this.phoneNumberId = phoneNumberId;
    }
}

