/*
 * Decompiled with CFR 0.152.
 */
package net.vivialconnect.model.format;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.vivialconnect.model.connector.Callback;
import net.vivialconnect.model.connector.PhoneNumber;
import net.vivialconnect.model.format.CallbackFormatter;
import net.vivialconnect.model.format.IntegerFormatter;
import net.vivialconnect.model.format.JsonValueFormatter;
import net.vivialconnect.model.format.ListFormatter;
import net.vivialconnect.model.format.PhoneNumberFormatter;
import net.vivialconnect.model.format.StringFormatter;

public class FormatterRegistry {
    private static FormatterRegistry instance;
    private Map<Class<?>, JsonValueFormatter> classToFormatterMap = new HashMap();

    private FormatterRegistry() {
        this.classToFormatterMap.put(String.class, new StringFormatter());
        this.classToFormatterMap.put(Integer.class, new IntegerFormatter());
        this.classToFormatterMap.put(ArrayList.class, new ListFormatter());
        this.classToFormatterMap.put(Callback.class, new CallbackFormatter());
        this.classToFormatterMap.put(PhoneNumber.class, new PhoneNumberFormatter());
    }

    public JsonValueFormatter getFormatter(Class<?> valueClass) {
        JsonValueFormatter formatter = this.classToFormatterMap.get(valueClass);
        if (formatter == null) {
            formatter = new StringFormatter();
        }
        return formatter;
    }

    public static FormatterRegistry getInstance() {
        if (instance == null) {
            instance = new FormatterRegistry();
        }
        return instance;
    }
}

