/*
 * Decompiled with CFR 0.152.
 */
package net.vivialconnect.model.log;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.vivialconnect.model.VivialConnectResource;
import net.vivialconnect.model.error.VivialConnectException;
import net.vivialconnect.model.log.LogCollection;
import net.vivialconnect.model.log.LogData;

public class Log
extends VivialConnectResource {
    private static final long serialVersionUID = -1982193020990089235L;
    @JsonProperty(value="log_id")
    private String logId;
    @JsonProperty(value="account_id")
    private int accountId;
    @JsonProperty(value="account_id_item_id")
    private String accountIdItemId;
    @JsonProperty(value="account_id_log_type")
    private String accountIdLogType;
    @JsonProperty(value="account_id_operator_id")
    private String accountIdOperatorId;
    @JsonProperty(value="log_type")
    private String logType;
    @JsonProperty(value="item_type")
    private String itemType;
    @JsonProperty(value="item_id")
    private String itemId;
    @JsonProperty(value="operator_type")
    private String operatorType;
    @JsonProperty(value="operator_id")
    private int operatorId;
    @JsonProperty(value="origin")
    private String origin;
    @JsonProperty(value="log_data")
    private LogData logData;
    @JsonProperty(value="log_data_json")
    private String logDataJson;
    @JsonProperty(value="log_timestamp")
    private String logTimestamp;
    @JsonProperty(value="description")
    private String description;

    public static LogCollection getLogs(Date startTime, Date endTime) throws VivialConnectException {
        return Log.getLogs(startTime, endTime, null);
    }

    public static LogCollection getLogs(Date startTime, Date endTime, Map<String, String> queryParameters) throws VivialConnectException {
        queryParameters = Log.buildQueryParams(startTime, endTime, null, queryParameters);
        return Log.request(VivialConnectResource.RequestMethod.GET, Log.classURL(Log.class), null, queryParameters, LogCollection.class);
    }

    public static LogCollection getAggregate(Date startTime, Date endTime, String aggregatorType) throws VivialConnectException {
        return Log.getAggregate(startTime, endTime, aggregatorType, null);
    }

    public static LogCollection getAggregate(Date startTime, Date endTime, String aggregatorType, Map<String, String> queryParameters) throws VivialConnectException {
        queryParameters = Log.buildQueryParams(startTime, endTime, aggregatorType, queryParameters);
        return Log.request(VivialConnectResource.RequestMethod.GET, Log.classURLWithSuffix(Log.class, "aggregate"), null, queryParameters, LogCollection.class);
    }

    private static Map<String, String> buildQueryParams(Date startTime, Date endTime, String aggregatorType, Map<String, String> queryParams) {
        String formattedStartDate = Log.createRequestTimestamp(startTime);
        String formattedEndDate = Log.createRequestTimestamp(endTime);
        if (queryParams == null) {
            queryParams = new HashMap<String, String>();
        }
        queryParams.put("start_time", formattedStartDate);
        queryParams.put("end_time", formattedEndDate);
        if (aggregatorType != null && !aggregatorType.isEmpty()) {
            queryParams.put("aggregator_type", aggregatorType);
        }
        return queryParams;
    }

    public String getLogId() {
        return this.logId;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public void setAccountId(int accountId) {
        this.accountId = accountId;
    }

    public String getAccountIdItemId() {
        return this.accountIdItemId;
    }

    public void setAccountIdItemId(String accountIdItemId) {
        this.accountIdItemId = accountIdItemId;
    }

    public String getAccountIdLogType() {
        return this.accountIdLogType;
    }

    public void setAccountIdLogType(String accountIdLogType) {
        this.accountIdLogType = accountIdLogType;
    }

    public String getAccountIdOperatorId() {
        return this.accountIdOperatorId;
    }

    public void setAccountIdOperatorId(String accountIdOperatorId) {
        this.accountIdOperatorId = accountIdOperatorId;
    }

    public String getLogType() {
        return this.logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getOperatorType() {
        return this.operatorType;
    }

    public void setOperatorType(String operatorType) {
        this.operatorType = operatorType;
    }

    public int getOperatorId() {
        return this.operatorId;
    }

    public void setOperatorId(int operatorId) {
        this.operatorId = operatorId;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public LogData getLogData() {
        return this.logData;
    }

    public void setLogData(LogData logData) {
        this.logData = logData;
    }

    public String getLogDataJson() {
        return this.logDataJson;
    }

    public void setLogDataJson(String logDataJson) {
        this.logDataJson = logDataJson;
    }

    public String getLogTimestamp() {
        return this.logTimestamp;
    }

    public void setLogTimestamp(String logTimestamp) {
        this.logTimestamp = logTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    static {
        classesWithoutRootValue.add(LogCollection.class);
    }
}

