/*
 * Decompiled with CFR 0.152.
 */
package net.vivialconnect.model.message;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.Date;
import net.vivialconnect.model.ResourceCount;
import net.vivialconnect.model.VivialConnectResource;
import net.vivialconnect.model.error.NoContentException;
import net.vivialconnect.model.error.VivialConnectException;
import net.vivialconnect.model.message.Message;

@JsonRootName(value="attachment")
public class Attachment
extends VivialConnectResource {
    private static final long serialVersionUID = 4189603597882262141L;
    @JsonProperty
    private int id;
    @JsonProperty(value="date_created")
    private Date dateCreated;
    @JsonProperty(value="date_modified")
    private Date dateModified;
    @JsonProperty(value="account_id")
    private int accountId;
    @JsonProperty(value="message_id")
    private int messageId;
    @JsonProperty(value="content_type")
    private String contentType;
    @JsonProperty(value="size")
    private int size;
    @JsonProperty(value="file_name")
    private String fileName;

    public static Attachment getAttachmentById(int messageId, int attachmentId) throws VivialConnectException {
        return Attachment.request(VivialConnectResource.RequestMethod.GET, Attachment.classURLWithSuffix(Message.class, String.format("%d/attachments/%d", messageId, attachmentId)), null, null, Attachment.class);
    }

    public static int count(int messageId) throws VivialConnectException {
        return Attachment.request(VivialConnectResource.RequestMethod.GET, Attachment.classURLWithSuffix(Message.class, String.format("%d/attachments/count", messageId)), null, null, ResourceCount.class).getCount();
    }

    public boolean delete() throws VivialConnectException {
        try {
            Attachment.request(VivialConnectResource.RequestMethod.DELETE, Attachment.classURLWithSuffix(Message.class, String.format("%d/attachments/%d", this.getMessageId(), this.getId())), null, null, String.class);
        }
        catch (NoContentException e) {
            return true;
        }
        return false;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public void setAccountId(int accountId) {
        this.accountId = accountId;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

