/*
 * Decompiled with CFR 0.152.
 */
package net.vivialconnect.model.message;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.vivialconnect.model.ResourceCount;
import net.vivialconnect.model.VivialConnectResource;
import net.vivialconnect.model.error.VivialConnectException;
import net.vivialconnect.model.format.JsonBodyBuilder;
import net.vivialconnect.model.message.Attachment;
import net.vivialconnect.model.message.AttachmentCollection;
import net.vivialconnect.model.message.MessageCollection;

@JsonRootName(value="message")
public class Message
extends VivialConnectResource {
    private static final long serialVersionUID = 5181807107956389186L;
    @JsonProperty
    private int id;
    @JsonProperty(value="date_created")
    private Date dateCreated;
    @JsonProperty(value="date_modified")
    private Date dateModified;
    @JsonProperty(value="account_id")
    private int accountId;
    @JsonProperty(value="master_account_id")
    private int masterAccountId;
    @JsonProperty(value="message_type")
    private String messageType;
    @JsonProperty
    private String direction;
    @JsonProperty(value="to_number")
    private String toNumber;
    @JsonProperty(value="from_number")
    private String fromNumber;
    @JsonProperty(value="connector_id")
    private int connectorId;
    @JsonProperty
    private Date sent;
    @JsonProperty(value="num_media")
    private int numMedia;
    @JsonProperty(value="num_segments")
    private int numSegments;
    @JsonProperty
    private String body;
    @JsonProperty
    private String status;
    @JsonProperty(value="error_code")
    private String errorCode;
    @JsonProperty(value="error_message")
    private String errorMessage;
    @JsonProperty
    private int price;
    @JsonProperty(value="price_currency")
    private String priceCurrency;
    private List<String> mediaUrls;

    public Message send() throws VivialConnectException {
        Message sentMessage = Message.request(VivialConnectResource.RequestMethod.POST, Message.classURL(Message.class), this.jsonBody(), null, Message.class);
        this.updateObjectState(sentMessage);
        return this;
    }

    private void updateObjectState(Message sentMessage) {
        this.id = sentMessage.getId();
        this.accountId = sentMessage.getAccountId();
        this.body = sentMessage.getBody();
        this.connectorId = sentMessage.getConnectorId();
        this.dateCreated = sentMessage.getDateCreated();
        this.dateModified = sentMessage.getDateModified();
        this.direction = sentMessage.getDirection();
        this.errorCode = sentMessage.getErrorCode();
        this.errorMessage = sentMessage.getErrorMessage();
        this.fromNumber = sentMessage.getFromNumber();
        this.toNumber = sentMessage.getToNumber();
        this.masterAccountId = sentMessage.getMasterAccountId();
        this.mediaUrls = sentMessage.getMediaUrls();
        this.messageType = sentMessage.getMessageType();
        this.numMedia = sentMessage.getNumMedia();
        this.numSegments = sentMessage.getNumSegments();
        this.price = sentMessage.getPrice();
        this.priceCurrency = sentMessage.getPriceCurrency();
        this.sent = sentMessage.getSent();
        this.status = sentMessage.getStatus();
    }

    private String jsonBody() {
        JsonBodyBuilder builder = JsonBodyBuilder.forClass(Message.class);
        if (this.hasMediaUrls()) {
            builder.addParamPair("media_urls", this.mediaUrls);
        }
        if (this.connectorId > 0) {
            builder.addParamPair("connector_id", this.connectorId);
        }
        return builder.addParamPair("from_number", this.fromNumber).addParamPair("to_number", this.toNumber).addParamPair("body", this.body).build();
    }

    private boolean hasMediaUrls() {
        return this.mediaUrls != null && !this.mediaUrls.isEmpty();
    }

    public static Message getMessageById(int messageId) throws VivialConnectException {
        return Message.request(VivialConnectResource.RequestMethod.GET, Message.classURLWithSuffix(Message.class, String.valueOf(messageId)), null, null, Message.class);
    }

    public static List<Message> getMessages() throws VivialConnectException {
        return Message.getMessages(null);
    }

    public static List<Message> getMessages(Map<String, String> queryParameters) throws VivialConnectException {
        return Message.request(VivialConnectResource.RequestMethod.GET, Message.classURL(Message.class), null, queryParameters, MessageCollection.class).getMessages();
    }

    public static int count() throws VivialConnectException {
        return Message.request(VivialConnectResource.RequestMethod.GET, Message.classURLWithSuffix(Message.class, "count"), null, null, ResourceCount.class).getCount();
    }

    public List<Attachment> getAttachments() throws VivialConnectException {
        return Message.request(VivialConnectResource.RequestMethod.GET, Message.classURLWithSuffix(Message.class, String.format("%d/attachments", this.getId())), null, null, AttachmentCollection.class).getAttachments();
    }

    public Message redact() throws VivialConnectException {
        Message redactedMessage = Message.request(VivialConnectResource.RequestMethod.PUT, Message.classURLWithSuffix(Message.class, String.valueOf(this.getId())), this.jsonBodyEmpty(), null, Message.class);
        this.updateObjectState(redactedMessage);
        return this;
    }

    private String jsonBodyEmpty() {
        return JsonBodyBuilder.forClass(Message.class).addParamPair("id", this.getId()).addParamPair("body", "").build();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public void setAccountId(int accountId) {
        this.accountId = accountId;
    }

    public int getMasterAccountId() {
        return this.masterAccountId;
    }

    public void setMasterAccountId(int masterAccountId) {
        this.masterAccountId = masterAccountId;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getToNumber() {
        return this.toNumber;
    }

    public void setToNumber(String toNumber) {
        this.toNumber = toNumber;
    }

    public String getFromNumber() {
        return this.fromNumber;
    }

    public void setFromNumber(String fromNumber) {
        this.fromNumber = fromNumber;
    }

    public int getConnectorId() {
        return this.connectorId;
    }

    public void setConnectorId(int connectorId) {
        this.connectorId = connectorId;
    }

    public Date getSent() {
        return this.sent;
    }

    public void setSent(Date sent) {
        this.sent = sent;
    }

    public int getNumMedia() {
        return this.numMedia;
    }

    public void setNumMedia(int numMedia) {
        this.numMedia = numMedia;
    }

    public int getNumSegments() {
        return this.numSegments;
    }

    public void setNumSegments(int numSegments) {
        this.numSegments = numSegments;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public int getPrice() {
        return this.price;
    }

    public void setPrice(int price) {
        this.price = price;
    }

    public String getPriceCurrency() {
        return this.priceCurrency;
    }

    public void setPriceCurrency(String priceCurrency) {
        this.priceCurrency = priceCurrency;
    }

    public Message addMediaUrl(String mediaUrl) {
        if (this.mediaUrls == null) {
            this.mediaUrls = new ArrayList<String>();
        }
        this.mediaUrls.add(mediaUrl);
        return this;
    }

    public List<String> getMediaUrls() {
        return this.mediaUrls;
    }

    public void setMediaUrls(List<String> mediaUrls) {
        this.mediaUrls = mediaUrls;
    }

    static {
        classesWithoutRootValue.add(MessageCollection.class);
        classesWithoutRootValue.add(AttachmentCollection.class);
    }
}

