/*
 * Decompiled with CFR 0.152.
 */
package net.vivialconnect.model.number;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.vivialconnect.model.ResourceCount;
import net.vivialconnect.model.VivialConnectResource;
import net.vivialconnect.model.error.NoContentException;
import net.vivialconnect.model.error.VivialConnectException;
import net.vivialconnect.model.format.JsonBodyBuilder;
import net.vivialconnect.model.number.AssociatedNumber;
import net.vivialconnect.model.number.AvailableNumber;
import net.vivialconnect.model.number.NumberCollection;
import net.vivialconnect.model.number.NumberInfo;

@JsonRootName(value="phone_number")
public class Number
extends VivialConnectResource
implements AssociatedNumber,
AvailableNumber {
    private static final long serialVersionUID = -1224802858893763457L;
    private static final String AVAILABLE_US_LOCAL = "available/US/local";
    @JsonProperty
    private int id;
    @JsonProperty(value="date_created")
    private Date dateCreated;
    @JsonProperty(value="date_modified")
    private Date dateModified;
    @JsonProperty(value="account_id")
    private int accountId;
    @JsonProperty
    private String name;
    @JsonProperty(value="phone_number")
    private String phoneNumber;
    @JsonProperty(value="phone_number_type")
    private String phoneNumberType;
    @JsonProperty(value="status_text_url")
    private String statusTextUrl;
    @JsonProperty(value="incoming_text_url")
    private String incomingTextUrl;
    @JsonProperty(value="incoming_text_method")
    private String incomingTextMethod;
    @JsonProperty(value="incoming_text_fallback_url")
    private String incomingTextFallbackUrl;
    @JsonProperty(value="incoming_text_fallback_method")
    private String incomingTextFallbackMethod;
    @JsonProperty(value="voice_forwarding_number")
    private String voiceForwardingNumber;
    @JsonProperty
    private String city;
    @JsonProperty
    private String region;
    @JsonProperty
    private String lata;
    @JsonProperty(value="rate_center")
    private String rateCenter;
    @JsonProperty
    private boolean active;
    @JsonProperty(value="connector_id")
    private int connectorId;

    @Override
    public AssociatedNumber update() throws VivialConnectException {
        AssociatedNumber number = Number.request(VivialConnectResource.RequestMethod.PUT, Number.classURLWithSuffix(Number.class, String.valueOf(this.getId())), this.buildJsonBodyForUpdate(), null, Number.class);
        this.updateObjectState(number);
        return this;
    }

    private String buildJsonBodyForUpdate() {
        JsonBodyBuilder builder = JsonBodyBuilder.withCustomClassName("phone_number");
        this.fillOptionalFieldsForUpdate(builder);
        return builder.build();
    }

    private void fillOptionalFieldsForUpdate(JsonBodyBuilder builder) {
        Number.ifParamValidAddToBuilder(builder, "id", this.getId());
        Number.ifParamValidAddToBuilder(builder, "connector_id", this.getConnectorId());
        Number.ifParamValidAddToBuilder(builder, "incoming_text_url", this.getIncomingTextUrl());
        Number.ifParamValidAddToBuilder(builder, "incoming_text_method", this.getIncomingTextMethod());
        Number.ifParamValidAddToBuilder(builder, "incoming_text_fallback_url", this.getIncomingTextFallbackUrl());
        Number.ifParamValidAddToBuilder(builder, "incoming_text_fallback_method", this.getIncomingTextFallbackMethod());
        Number.ifParamValidAddToBuilder(builder, "voice_forwarding_number", this.getVoiceForwardingNumber());
    }

    private void updateObjectState(AssociatedNumber number) {
        this.id = number.getId();
        this.dateCreated = number.getDateCreated();
        this.dateModified = number.getDateModified();
        this.accountId = number.getAccountId();
        this.phoneNumber = number.getPhoneNumber();
        this.phoneNumberType = number.getPhoneNumberType();
        this.statusTextUrl = number.getStatusTextUrl();
        this.incomingTextUrl = number.getIncomingTextUrl();
        this.incomingTextMethod = number.getIncomingTextMethod();
        this.incomingTextFallbackUrl = number.getIncomingTextFallbackUrl();
        this.incomingTextFallbackMethod = number.getIncomingTextFallbackMethod();
        this.voiceForwardingNumber = number.getVoiceForwardingNumber();
        this.city = number.getCity();
        this.region = number.getRegion();
        this.lata = number.getLata();
        this.rateCenter = number.getRateCenter();
        this.active = number.isActive();
        this.connectorId = number.getConnectorId();
    }

    @Override
    public AssociatedNumber updateLocalNumber() throws VivialConnectException {
        this.ensureNumberIsLocal();
        AssociatedNumber number = Number.request(VivialConnectResource.RequestMethod.PUT, Number.classURLWithSuffix(Number.class, String.format("local/%d", this.getId())), this.buildJsonBodyForUpdate(), null, Number.class);
        this.updateObjectState(number);
        return this;
    }

    private void ensureNumberIsLocal() {
        if (!"local".equals(this.phoneNumberType)) {
            throw new UnsupportedOperationException("Number is not local");
        }
    }

    @Override
    public boolean delete() throws VivialConnectException {
        try {
            Number.request(VivialConnectResource.RequestMethod.DELETE, Number.classURLWithSuffix(Number.class, String.valueOf(this.getId())), null, null, String.class);
        }
        catch (NoContentException e) {
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteLocalNumber() throws VivialConnectException {
        this.ensureNumberIsLocal();
        try {
            Number.request(VivialConnectResource.RequestMethod.DELETE, Number.classURLWithSuffix(Number.class, String.format("local/%d", this.getId())), null, null, String.class);
        }
        catch (NoContentException e) {
            return true;
        }
        return false;
    }

    @Override
    public AssociatedNumber buy() throws VivialConnectException {
        JsonBodyBuilder builder = JsonBodyBuilder.withCustomClassName("phone_number").addParamPair("phone_number", this.getPhoneNumber()).addParamPair("phone_number_type", this.getPhoneNumberType());
        this.fillOptionalFieldsForBuy(builder);
        return Number.request(VivialConnectResource.RequestMethod.POST, Number.classURL(Number.class), builder.build(), null, Number.class);
    }

    private void fillOptionalFieldsForBuy(JsonBodyBuilder builder) {
        Number.ifParamValidAddToBuilder(builder, "name", this.getName());
        Number.ifParamValidAddToBuilder(builder, "status_text_url", this.getStatusTextUrl());
        Number.ifParamValidAddToBuilder(builder, "connector_id", this.getConnectorId());
        Number.ifParamValidAddToBuilder(builder, "incoming_text_url", this.getIncomingTextUrl());
        Number.ifParamValidAddToBuilder(builder, "incoming_text_method", this.getIncomingTextMethod());
        Number.ifParamValidAddToBuilder(builder, "incoming_text_fallback_url", this.getIncomingTextFallbackUrl());
        Number.ifParamValidAddToBuilder(builder, "incoming_text_fallback_method", this.getIncomingTextFallbackMethod());
    }

    public static AssociatedNumber buyLocalNumber(String phoneNumber, String areaCode, Map<String, Object> optionalParams) throws VivialConnectException {
        JsonBodyBuilder builder = JsonBodyBuilder.withCustomClassName("phone_number");
        if (optionalParams != null) {
            builder = builder.addParams(optionalParams);
        }
        Number.ifParamValidAddToBuilder(builder, "phone_number", phoneNumber);
        Number.ifParamValidAddToBuilder(builder, "area_code", areaCode);
        return Number.request(VivialConnectResource.RequestMethod.POST, Number.classURLWithSuffix(Number.class, "local"), builder.build(), null, Number.class);
    }

    public static AssociatedNumber buy(String phoneNumber, String areaCode, String phoneNumberType, Map<String, Object> optionalParams) throws VivialConnectException {
        JsonBodyBuilder builder = JsonBodyBuilder.withCustomClassName("phone_number");
        if (optionalParams != null) {
            builder = builder.addParams(optionalParams);
        }
        Number.ifParamValidAddToBuilder(builder, "phone_number", phoneNumber);
        Number.ifParamValidAddToBuilder(builder, "area_code", areaCode);
        Number.ifParamValidAddToBuilder(builder, "phone_number_type", phoneNumberType);
        return Number.request(VivialConnectResource.RequestMethod.POST, Number.classURL(Number.class), builder.build(), null, Number.class);
    }

    public static List<AssociatedNumber> getAssociatedNumbers() throws VivialConnectException {
        return Number.getAssociatedNumbers(null);
    }

    public static List<AssociatedNumber> getAssociatedNumbers(Map<String, String> queryParams) throws VivialConnectException {
        return Number.request(VivialConnectResource.RequestMethod.GET, Number.classURL(Number.class), null, queryParams, NumberCollection.class).getAssociatedNumbers();
    }

    public static List<AvailableNumber> findAvailableNumbersInRegion(String region) throws VivialConnectException {
        return Number.findAvailableNumbersInRegion(region, null);
    }

    public static List<AvailableNumber> findAvailableNumbersInRegion(String region, Map<String, String> queryParams) throws VivialConnectException {
        return Number.request(VivialConnectResource.RequestMethod.GET, Number.classURLWithSuffix(Number.class, AVAILABLE_US_LOCAL), null, Number.addQueryParam("in_region", region, queryParams), NumberCollection.class).getAvailableNumbers();
    }

    public static List<AvailableNumber> findAvailableNumbersByAreaCode(String areaCode) throws VivialConnectException {
        return Number.findAvailableNumbersByAreaCode(areaCode, null);
    }

    public static List<AvailableNumber> findAvailableNumbersByAreaCode(String areaCode, Map<String, String> queryParams) throws VivialConnectException {
        return Number.request(VivialConnectResource.RequestMethod.GET, Number.classURLWithSuffix(Number.class, AVAILABLE_US_LOCAL), null, Number.addQueryParam("area_code", areaCode, queryParams), NumberCollection.class).getAvailableNumbers();
    }

    public static List<AvailableNumber> findAvailableNumbersByPostalCode(String postalCode) throws VivialConnectException {
        return Number.findAvailableNumbersByPostalCode(postalCode, null);
    }

    public static List<AvailableNumber> findAvailableNumbersByPostalCode(String postalCode, Map<String, String> queryParams) throws VivialConnectException {
        return Number.request(VivialConnectResource.RequestMethod.GET, Number.classURLWithSuffix(Number.class, AVAILABLE_US_LOCAL), null, Number.addQueryParam("in_postal_code", postalCode, queryParams), NumberCollection.class).getAvailableNumbers();
    }

    public static List<AssociatedNumber> getLocalAssociatedNumbers() throws VivialConnectException {
        return Number.getLocalAssociatedNumbers(null);
    }

    public static List<AssociatedNumber> getLocalAssociatedNumbers(Map<String, String> queryParams) throws VivialConnectException {
        return Number.request(VivialConnectResource.RequestMethod.GET, Number.classURLWithSuffix(Number.class, "local"), null, queryParams, NumberCollection.class).getAssociatedNumbers();
    }

    public static int count() throws VivialConnectException {
        return Number.request(VivialConnectResource.RequestMethod.GET, Number.classURLWithSuffix(Number.class, "count"), null, null, ResourceCount.class).getCount();
    }

    public static int countLocal() throws VivialConnectException {
        return Number.request(VivialConnectResource.RequestMethod.GET, Number.classURLWithSuffix(Number.class, "local/count"), null, null, ResourceCount.class).getCount();
    }

    public static AssociatedNumber getNumberById(int numberId) throws VivialConnectException {
        return Number.request(VivialConnectResource.RequestMethod.GET, Number.classURLWithSuffix(Number.class, String.valueOf(numberId)), null, null, Number.class);
    }

    public static AssociatedNumber getLocalNumberById(int numberId) throws VivialConnectException {
        return Number.request(VivialConnectResource.RequestMethod.GET, Number.classURLWithSuffix(Number.class, String.format("local/%d", numberId)), null, null, Number.class);
    }

    @Override
    public NumberInfo lookup() throws VivialConnectException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("phone_number", this.getRawPhoneNumber());
        return Number.request(VivialConnectResource.RequestMethod.GET, Number.classURLWithSuffix(Number.class, "lookup"), null, queryParams, NumberInfo.class);
    }

    private String getRawPhoneNumber() {
        return this.getPhoneNumber().substring(1);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @Override
    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Override
    public Date getDateModified() {
        return this.dateModified;
    }

    @Override
    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    @Override
    public int getAccountId() {
        return this.accountId;
    }

    @Override
    public void setAccountId(int accountId) {
        this.accountId = accountId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @Override
    public String getPhoneNumberType() {
        return this.phoneNumberType;
    }

    @Override
    public void setPhoneNumberType(String phoneNumberType) {
        this.phoneNumberType = phoneNumberType;
    }

    @Override
    public String getStatusTextUrl() {
        return this.statusTextUrl;
    }

    @Override
    public void setStatusTextUrl(String statusTextUrl) {
        this.statusTextUrl = statusTextUrl;
    }

    @Override
    public String getIncomingTextUrl() {
        return this.incomingTextUrl;
    }

    @Override
    public void setIncomingTextUrl(String incomingTextUrl) {
        this.incomingTextUrl = incomingTextUrl;
    }

    @Override
    public String getIncomingTextMethod() {
        return this.incomingTextMethod;
    }

    @Override
    public void setIncomingTextMethod(String incomingTextMethod) {
        this.incomingTextMethod = incomingTextMethod;
    }

    @Override
    public String getIncomingTextFallbackUrl() {
        return this.incomingTextFallbackUrl;
    }

    @Override
    public void setIncomingTextFallbackUrl(String incomingTextFallbackUrl) {
        this.incomingTextFallbackUrl = incomingTextFallbackUrl;
    }

    @Override
    public String getIncomingTextFallbackMethod() {
        return this.incomingTextFallbackMethod;
    }

    @Override
    public void setIncomingTextFallbackMethod(String incomingTextFallbackMethod) {
        this.incomingTextFallbackMethod = incomingTextFallbackMethod;
    }

    @Override
    public String getVoiceForwardingNumber() {
        return this.voiceForwardingNumber;
    }

    @Override
    public void setVoiceForwardingNumber(String voiceForwardingNumber) {
        this.voiceForwardingNumber = voiceForwardingNumber;
    }

    @Override
    public String getCity() {
        return this.city;
    }

    @Override
    public void setCity(String city) {
        this.city = city;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public void setRegion(String region) {
        this.region = region;
    }

    @Override
    public String getLata() {
        return this.lata;
    }

    @Override
    public void setLata(String lata) {
        this.lata = lata;
    }

    @Override
    public String getRateCenter() {
        return this.rateCenter;
    }

    @Override
    public void setRateCenter(String rateCenter) {
        this.rateCenter = rateCenter;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public int getConnectorId() {
        return this.connectorId;
    }

    @Override
    public void setConnectorId(int connectorId) {
        this.connectorId = connectorId;
    }

    static {
        classesWithoutRootValue.add(NumberCollection.class);
    }
}

