/*
 * Decompiled with CFR 0.152.
 */
package net.vivialconnect.model.user;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.vivialconnect.model.ResourceCount;
import net.vivialconnect.model.VivialConnectResource;
import net.vivialconnect.model.error.NoContentException;
import net.vivialconnect.model.error.VivialConnectException;
import net.vivialconnect.model.format.JsonBodyBuilder;
import net.vivialconnect.model.user.Role;
import net.vivialconnect.model.user.UserCollection;

@JsonRootName(value="user")
public class User
extends VivialConnectResource {
    private static final long serialVersionUID = 6871296061820754520L;
    @JsonProperty
    private int id;
    @JsonProperty(value="date_created")
    private Date dateCreated;
    @JsonProperty(value="date_modified")
    private Date dateModified;
    @JsonProperty(value="account_id")
    private int accountId;
    @JsonProperty
    private boolean active;
    @JsonProperty
    private boolean verified;
    @JsonProperty(value="api_key")
    private String apiKey;
    @JsonProperty
    private String timezone;
    @JsonProperty
    private String username;
    @JsonProperty(value="first_name")
    private String firstName;
    @JsonProperty(value="last_name")
    private String lastName;
    @JsonProperty
    private String email;
    @JsonProperty
    private List<Role> roles;

    public static User getUserById(int userId) throws VivialConnectException {
        return User.request(VivialConnectResource.RequestMethod.GET, User.classURLWithSuffix(User.class, String.valueOf(userId)), null, null, User.class);
    }

    public static List<User> getUsers() throws VivialConnectException {
        return User.getUsers(null);
    }

    public static List<User> getUsers(Map<String, String> queryParams) throws VivialConnectException {
        return User.request(VivialConnectResource.RequestMethod.GET, User.classURL(User.class), null, queryParams, UserCollection.class).getUsers();
    }

    public static int count() throws VivialConnectException {
        return User.request(VivialConnectResource.RequestMethod.GET, User.classURLWithSuffix(User.class, "count"), null, null, ResourceCount.class).getCount();
    }

    public boolean delete() throws VivialConnectException {
        try {
            User.request(VivialConnectResource.RequestMethod.DELETE, User.classURLWithSuffix(User.class, String.valueOf(this.getId())), null, null, String.class);
        }
        catch (NoContentException nce) {
            return true;
        }
        return false;
    }

    public boolean changePassword(String oldPassword, String newPassword) throws VivialConnectException {
        JsonBodyBuilder builder = JsonBodyBuilder.forClass(User.class).addParamPair("_password", oldPassword).addParamPair("password", newPassword);
        String result = User.request(VivialConnectResource.RequestMethod.PUT, User.classURLWithSuffix(User.class, String.format("%d/profile/password", this.getId())), builder.build(), null, String.class);
        return "{}".equals(result);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public void setAccountId(int accountId) {
        this.accountId = accountId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    static {
        classesWithoutRootValue.add(UserCollection.class);
    }
}

