/*
 * Decompiled with CFR 0.152.
 */
package krm2;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class ed25519 {
    static final int b = 256;
    static final BigInteger q = new BigInteger("57896044618658097711785492504343953926634992332820282019728792003956564819949");
    static final BigInteger qm2 = new BigInteger("57896044618658097711785492504343953926634992332820282019728792003956564819947");
    static final BigInteger qp3 = new BigInteger("57896044618658097711785492504343953926634992332820282019728792003956564819952");
    static final BigInteger l = new BigInteger("7237005577332262213973186563042994240857116359379907606001950938285454250989");
    static final BigInteger d = new BigInteger("-4513249062541557337682894930092624173785641285191125241628941591882900924598840740");
    static final BigInteger I = new BigInteger("19681161376707505956807079304988542015446066515923890162744021073123829784752");
    static final BigInteger By = new BigInteger("46316835694926478169428394003475163141307993866256225615783033603165251855960");
    static final BigInteger Bx = new BigInteger("15112221349535400772501151409588531511454012693041857206046113283949847762202");
    static final BigInteger[] B = new BigInteger[]{Bx.mod(q), By.mod(q)};
    static final BigInteger un = new BigInteger("57896044618658097711785492504343953926634992332820282019728792003956564819967");

    static byte[] H(byte[] m) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            md.reset();
            return md.digest(m);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    static BigInteger expmod(BigInteger b, BigInteger e, BigInteger m) {
        if (e.equals(BigInteger.ZERO)) {
            return BigInteger.ONE;
        }
        BigInteger t = ed25519.expmod(b, e.divide(BigInteger.valueOf(2L)), m).pow(2).mod(m);
        if (e.testBit(0)) {
            t = t.multiply(b).mod(m);
        }
        return t;
    }

    static BigInteger inv(BigInteger x) {
        return ed25519.expmod(x, qm2, q);
    }

    static BigInteger xrecover(BigInteger y) {
        BigInteger y2 = y.multiply(y);
        BigInteger xx = y2.subtract(BigInteger.ONE).multiply(ed25519.inv(d.multiply(y2).add(BigInteger.ONE)));
        BigInteger x = ed25519.expmod(xx, qp3.divide(BigInteger.valueOf(8L)), q);
        if (!x.multiply(x).subtract(xx).mod(q).equals(BigInteger.ZERO)) {
            x = x.multiply(I).mod(q);
        }
        if (!x.mod(BigInteger.valueOf(2L)).equals(BigInteger.ZERO)) {
            x = q.subtract(x);
        }
        return x;
    }

    static BigInteger[] edwards(BigInteger[] P, BigInteger[] Q) {
        BigInteger x1 = P[0];
        BigInteger y1 = P[1];
        BigInteger x2 = Q[0];
        BigInteger y2 = Q[1];
        BigInteger dtemp = d.multiply(x1).multiply(x2).multiply(y1).multiply(y2);
        BigInteger x3 = x1.multiply(y2).add(x2.multiply(y1)).multiply(ed25519.inv(BigInteger.ONE.add(dtemp)));
        BigInteger y3 = y1.multiply(y2).add(x1.multiply(x2)).multiply(ed25519.inv(BigInteger.ONE.subtract(dtemp)));
        return new BigInteger[]{x3.mod(q), y3.mod(q)};
    }

    static BigInteger[] scalarmult(BigInteger[] P, BigInteger e) {
        if (e.equals(BigInteger.ZERO)) {
            return new BigInteger[]{BigInteger.ZERO, BigInteger.ONE};
        }
        BigInteger[] Q = ed25519.scalarmult(P, e.divide(BigInteger.valueOf(2L)));
        Q = ed25519.edwards(Q, Q);
        if (e.testBit(0)) {
            Q = ed25519.edwards(Q, P);
        }
        return Q;
    }

    static byte[] encodeint(BigInteger y) {
        byte[] in = y.toByteArray();
        byte[] out = new byte[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[in.length - 1 - i];
        }
        return out;
    }

    static byte[] encodepoint(BigInteger[] P) {
        BigInteger x = P[0];
        BigInteger y = P[1];
        byte[] out = ed25519.encodeint(y);
        int n = out.length - 1;
        out[n] = (byte)(out[n] | (x.testBit(0) ? 128 : 0));
        return out;
    }

    static int bit(byte[] h, int i) {
        return h[i / 8] >> i % 8 & 1;
    }

    public static byte[] publickey(byte[] sk) {
        byte[] h = ed25519.H(sk);
        BigInteger a = BigInteger.valueOf(2L).pow(254);
        for (int i = 3; i < 254; ++i) {
            BigInteger apart = BigInteger.valueOf(2L).pow(i).multiply(BigInteger.valueOf(ed25519.bit(h, i)));
            a = a.add(apart);
        }
        BigInteger[] A = ed25519.scalarmult(B, a);
        return ed25519.encodepoint(A);
    }

    static BigInteger Hint(byte[] m) {
        byte[] h = ed25519.H(m);
        BigInteger hsum = BigInteger.ZERO;
        for (int i = 0; i < 512; ++i) {
            hsum = hsum.add(BigInteger.valueOf(2L).pow(i).multiply(BigInteger.valueOf(ed25519.bit(h, i))));
        }
        return hsum;
    }

    public static byte[] signature(byte[] m, byte[] sk, byte[] pk) {
        byte[] h = ed25519.H(sk);
        BigInteger a = BigInteger.valueOf(2L).pow(254);
        for (int i = 3; i < 254; ++i) {
            a = a.add(BigInteger.valueOf(2L).pow(i).multiply(BigInteger.valueOf(ed25519.bit(h, i))));
        }
        ByteBuffer rsub = ByteBuffer.allocate(32 + m.length);
        rsub.put(h, 32, 32).put(m);
        BigInteger r = ed25519.Hint(rsub.array());
        BigInteger[] R = ed25519.scalarmult(B, r);
        ByteBuffer Stemp = ByteBuffer.allocate(32 + pk.length + m.length);
        Stemp.put(ed25519.encodepoint(R)).put(pk).put(m);
        BigInteger S = r.add(ed25519.Hint(Stemp.array()).multiply(a)).mod(l);
        ByteBuffer out = ByteBuffer.allocate(64);
        out.put(ed25519.encodepoint(R)).put(ed25519.encodeint(S));
        return out.array();
    }

    static boolean isoncurve(BigInteger[] P) {
        BigInteger x = P[0];
        BigInteger y = P[1];
        BigInteger xx = x.multiply(x);
        BigInteger yy = y.multiply(y);
        BigInteger dxxyy = d.multiply(yy).multiply(xx);
        return xx.negate().add(yy).subtract(BigInteger.ONE).subtract(dxxyy).mod(q).equals(BigInteger.ZERO);
    }

    static BigInteger decodeint(byte[] s) {
        byte[] out = new byte[s.length];
        for (int i = 0; i < s.length; ++i) {
            out[i] = s[s.length - 1 - i];
        }
        return new BigInteger(out).and(un);
    }

    static BigInteger[] decodepoint(byte[] s) throws Exception {
        BigInteger[] P;
        byte[] ybyte = new byte[s.length];
        for (int i = 0; i < s.length; ++i) {
            ybyte[i] = s[s.length - 1 - i];
        }
        BigInteger y = new BigInteger(ybyte).and(un);
        BigInteger x = ed25519.xrecover(y);
        if ((x.testBit(0) ? 1 : 0) != ed25519.bit(s, 255)) {
            x = q.subtract(x);
        }
        if (!ed25519.isoncurve(P = new BigInteger[]{x, y})) {
            throw new Exception("decoding point that is not on curve");
        }
        return P;
    }

    public static boolean checkvalid(byte[] s, byte[] m, byte[] pk) throws Exception {
        if (s.length != 64) {
            throw new Exception("signature length is wrong");
        }
        if (pk.length != 32) {
            throw new Exception("public-key length is wrong");
        }
        byte[] Rbyte = Arrays.copyOfRange(s, 0, 32);
        BigInteger[] R = ed25519.decodepoint(Rbyte);
        BigInteger[] A = ed25519.decodepoint(pk);
        byte[] Sbyte = Arrays.copyOfRange(s, 32, 64);
        BigInteger S = ed25519.decodeint(Sbyte);
        ByteBuffer Stemp = ByteBuffer.allocate(32 + pk.length + m.length);
        Stemp.put(ed25519.encodepoint(R)).put(pk).put(m);
        BigInteger h = ed25519.Hint(Stemp.array());
        BigInteger[] ra = ed25519.scalarmult(B, S);
        BigInteger[] rb = ed25519.edwards(R, ed25519.scalarmult(A, h));
        return ra[0].equals(rb[0]) && ra[1].equals(rb[1]);
    }
}

