/*
 * Decompiled with CFR 0.152.
 */
package net.vrallev.java.ecc;

import djb.Curve25519;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import krm2.ed25519;
import net.vrallev.java.ecc.KeyHolder;

public class Ecc25519Helper {
    protected static final MessageDigest MESSAGE_DIGEST_SHA_256;
    private final KeyHolder mKeyHolder;

    public Ecc25519Helper() {
        this((KeyHolder)null);
    }

    public Ecc25519Helper(byte[] privateKey) {
        this(new KeyHolder(privateKey));
    }

    public Ecc25519Helper(KeyHolder keyHolder) {
        this.mKeyHolder = keyHolder;
    }

    public byte[] diffieHellman() {
        return this.diffieHellman(this.mKeyHolder.getPrivateKey(), this.mKeyHolder.getPublicKeyDiffieHellman());
    }

    public byte[] diffieHellman(byte[] privateKey, byte[] publicKey) {
        byte[] sharedSecret = new byte[32];
        Curve25519.curve(sharedSecret, privateKey, publicKey);
        MESSAGE_DIGEST_SHA_256.reset();
        return MESSAGE_DIGEST_SHA_256.digest(sharedSecret);
    }

    public byte[] sign(byte[] message) {
        return this.sign(message, this.mKeyHolder.getPrivateKey(), this.mKeyHolder.getPublicKeySignature());
    }

    public byte[] sign(byte[] message, byte[] privateKey, byte[] publicKey) {
        try {
            return ed25519.signature(message, privateKey, publicKey);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean isValidSignature(byte[] message, byte[] signature) {
        return this.isValidSignature(message, signature, this.mKeyHolder.getPublicKeySignature());
    }

    public boolean isValidSignature(byte[] message, byte[] signature, byte[] publicKey) {
        try {
            return ed25519.checkvalid(signature, message, publicKey);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public KeyHolder getKeyHolder() {
        return this.mKeyHolder;
    }

    static {
        try {
            MESSAGE_DIGEST_SHA_256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

