/*
 * Decompiled with CFR 0.152.
 */
package net.vrallev.java.ecc;

import djb.Curve25519;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import krm2.ed25519;

public class KeyHolder {
    protected static final MessageDigest MESSAGE_DIGEST_SHA_256;
    protected final byte[] mPrivateKey;
    protected final byte[] mPublicKeyDiffieHellman;
    protected final byte[] mPublicKeySignature;

    public static byte[] createPrivateKey(byte[] seed) {
        MESSAGE_DIGEST_SHA_256.reset();
        return MESSAGE_DIGEST_SHA_256.digest(seed);
    }

    public KeyHolder(byte[] privateKey) {
        if (privateKey == null || privateKey.length != 32 && privateKey.length != 64) {
            throw new IllegalArgumentException("private key must contain 32 or 64 bytes.");
        }
        Curve25519.clamp(privateKey);
        this.mPrivateKey = Arrays.copyOf(privateKey, privateKey.length);
        this.mPublicKeyDiffieHellman = new byte[32];
        Curve25519.keygen(this.mPublicKeyDiffieHellman, null, this.mPrivateKey);
        this.mPublicKeySignature = this.computePublicSignatureKey(this.mPrivateKey);
    }

    public KeyHolder(byte[] publicKeyDiffieHellman, byte[] publicKeySignature) {
        this(null, publicKeyDiffieHellman, publicKeySignature);
    }

    public KeyHolder(byte[] privateKey, byte[] publicKeyDiffieHellman, byte[] publicKeySignature) {
        this.mPrivateKey = privateKey;
        this.mPublicKeyDiffieHellman = publicKeyDiffieHellman;
        this.mPublicKeySignature = publicKeySignature;
    }

    protected byte[] computePublicSignatureKey(byte[] privateKey) {
        return ed25519.publickey(privateKey);
    }

    public byte[] getPrivateKey() {
        return this.mPrivateKey;
    }

    public byte[] getPublicKeyDiffieHellman() {
        return this.mPublicKeyDiffieHellman;
    }

    public byte[] getPublicKeySignature() {
        return this.mPublicKeySignature;
    }

    static {
        try {
            MESSAGE_DIGEST_SHA_256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

