/*
 * Decompiled with CFR 0.152.
 */
package net.vvakame.memvache;

import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.vvakame.memvache.MemcacheKeyUtil;
import net.vvakame.memvache.MemvacheDelegate;
import net.vvakame.memvache.Pair;
import net.vvakame.memvache.RpcVisitor;

public class AggressiveQueryCacheStrategy
extends RpcVisitor {
    static final int PRIORITY = 1000;
    static final Settings settings = Settings.getInstance();

    @Override
    public int getPriority() {
        return 1000;
    }

    @Override
    public Pair<byte[], byte[]> pre_datastore_v3_RunQuery(DatastorePb.Query requestPb) {
        String memcacheKey;
        MemcacheService memcache;
        byte[] data;
        if (AggressiveQueryCacheStrategy.isIgnoreKind(requestPb.getKind())) {
            return null;
        }
        if (requestPb.getCount() == 0) {
            requestPb.setCount(1000);
        }
        if ((data = (byte[])(memcache = MemvacheDelegate.getMemcache()).get((Object)(memcacheKey = MemcacheKeyUtil.createQueryKey(memcache, requestPb)))) == null) {
            return Pair.request(requestPb.toByteArray());
        }
        try {
            int readSize;
            GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(data));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[0x100000];
            while ((readSize = gis.read(buffer)) != -1) {
                baos.write(buffer, 0, readSize);
            }
            baos.flush();
            DatastorePb.QueryResult response = new DatastorePb.QueryResult();
            response.mergeFrom(baos.toByteArray());
            return Pair.response(response.toByteArray());
        }
        catch (IOException e) {
            return Pair.request(requestPb.toByteArray());
        }
    }

    @Override
    public byte[] post_datastore_v3_RunQuery(DatastorePb.Query requestPb, DatastorePb.QueryResult responsePb) {
        if (AggressiveQueryCacheStrategy.isIgnoreKind(requestPb.getKind())) {
            return null;
        }
        MemcacheService memcache = MemvacheDelegate.getMemcache();
        String memcacheKey = MemcacheKeyUtil.createQueryKey(memcache, requestPb);
        Expiration expiration = Expiration.byDeltaSeconds((int)settings.getExpireSecond());
        byte[] result = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(baos);
            gos.write(responsePb.toByteArray());
            gos.flush();
            gos.finish();
            result = baos.toByteArray();
        }
        catch (IOException e) {
            // empty catch block
        }
        memcache.put((Object)memcacheKey, result, expiration);
        return null;
    }

    @Override
    public Pair<byte[], byte[]> pre_datastore_v3_Put(DatastorePb.PutRequest requestPb) {
        MemcacheService memcache = MemvacheDelegate.getMemcache();
        HashSet<String> memcacheKeys = new HashSet<String>();
        StringBuilder builder = new StringBuilder();
        for (OnestoreEntity.EntityProto entity : requestPb.entitys()) {
            OnestoreEntity.Reference key = entity.getMutableKey();
            String namespace = key.getNameSpace();
            OnestoreEntity.Path path = key.getPath();
            List elements = path.mutableElements();
            OnestoreEntity.Path.Element element = (OnestoreEntity.Path.Element)elements.get(elements.size() - 1);
            String kind = element.getType();
            if (AggressiveQueryCacheStrategy.isIgnoreKind(kind)) continue;
            builder.setLength(0);
            String memcacheKey = MemcacheKeyUtil.createKindKey(builder, namespace, kind);
            memcacheKeys.add(memcacheKey);
        }
        for (String key : memcacheKeys) {
            memcache.increment((Object)key, 1L, Long.valueOf(0L));
        }
        return null;
    }

    @Override
    public Pair<byte[], byte[]> pre_datastore_v3_Delete(DatastorePb.DeleteRequest requestPb) {
        MemcacheService memcache = MemvacheDelegate.getMemcache();
        HashSet<String> memcacheKeys = new HashSet<String>();
        StringBuilder builder = new StringBuilder();
        for (OnestoreEntity.Reference reference : requestPb.mutableKeys()) {
            String namespace = reference.getNameSpace();
            OnestoreEntity.Path path = reference.getPath();
            List elements = path.mutableElements();
            OnestoreEntity.Path.Element element = (OnestoreEntity.Path.Element)elements.get(elements.size() - 1);
            String kind = element.getType();
            if (AggressiveQueryCacheStrategy.isIgnoreKind(kind)) continue;
            builder.setLength(0);
            String memcacheKey = MemcacheKeyUtil.createKindKey(builder, namespace, kind);
            memcacheKeys.add(memcacheKey);
        }
        for (String string : memcacheKeys) {
            memcache.increment((Object)string, 1L, Long.valueOf(0L));
        }
        return super.pre_datastore_v3_Delete(requestPb);
    }

    public static boolean isIgnoreKind(String kind) {
        if (kind.startsWith("__")) {
            return true;
        }
        if ("".equals(kind)) {
            return true;
        }
        return settings.getIgnoreKinds().contains(kind);
    }

    @Override
    public Pair<byte[], byte[]> pre_datastore_v3_Next(DatastorePb.NextRequest requestPb) {
        return super.pre_datastore_v3_Next(requestPb);
    }

    @Override
    public byte[] post_datastore_v3_Next(DatastorePb.NextRequest requestPb, DatastorePb.QueryResult responsePb) {
        return super.post_datastore_v3_Next(requestPb, responsePb);
    }

    static class Settings {
        static final Logger logger = Logger.getLogger(Settings.class.getName());
        int expireSecond = 300;
        Set<String> ignoreKinds = new HashSet<String>();
        static Settings singleton;

        public static Settings getInstance() {
            if (singleton == null) {
                singleton = new Settings();
            }
            return singleton;
        }

        Settings() {
            Properties properties = new Properties();
            try {
                String ignoreKindStr;
                InputStream is = Settings.class.getResourceAsStream("/memvache.properties");
                if (is == null) {
                    return;
                }
                properties.load(is);
                String expireSecondStr = properties.getProperty("expireSecond");
                if (expireSecondStr != null && !"".equals(expireSecondStr)) {
                    this.expireSecond = Integer.parseInt(expireSecondStr);
                }
                this.ignoreKinds = (ignoreKindStr = properties.getProperty("ignoreKind")) != null && !"".equals(ignoreKindStr) ? new HashSet<String>(Arrays.asList(ignoreKindStr.split(","))) : new HashSet<String>();
            }
            catch (IOException e) {
                logger.log(Level.INFO, "", e);
            }
        }

        public int getExpireSecond() {
            return this.expireSecond;
        }

        public void setExpireSecond(int expireSecond) {
            this.expireSecond = expireSecond;
        }

        public Set<String> getIgnoreKinds() {
            return this.ignoreKinds;
        }

        public void setIgnoreKinds(Set<String> ignoreKinds) {
            this.ignoreKinds = ignoreKinds;
        }
    }
}

