/*
 * Decompiled with CFR 0.152.
 */
package net.vvakame.memvache;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyTranslatorPublic;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.vvakame.memvache.MemvacheDelegate;
import net.vvakame.memvache.Pair;
import net.vvakame.memvache.PbKeyUtil;
import net.vvakame.memvache.RpcVisitor;

public class GetPutCacheStrategy
extends RpcVisitor {
    static final int PRIORITY = 3000;
    Map<DatastorePb.GetRequest, List<Key>> requestKeysMap = new HashMap<DatastorePb.GetRequest, List<Key>>();
    Map<DatastorePb.GetRequest, Map<Key, DatastorePb.GetResponse.Entity>> dataMap = new HashMap<DatastorePb.GetRequest, Map<Key, DatastorePb.GetResponse.Entity>>();
    Map<DatastorePb.GetRequest, Integer> requestCountMap = new HashMap<DatastorePb.GetRequest, Integer>();
    Map<Long, Map<Key, DatastorePb.GetResponse.Entity>> putUnderTx = new HashMap<Long, Map<Key, DatastorePb.GetResponse.Entity>>();

    @Override
    public int getPriority() {
        return 3000;
    }

    @Override
    public Pair<byte[], byte[]> pre_datastore_v3_Get(DatastorePb.GetRequest requestPb) {
        if (requestPb.getTransaction().hasApp()) {
            return null;
        }
        List<Key> requestKeys = PbKeyUtil.toKeys(requestPb.keys());
        HashMap<Key, DatastorePb.GetResponse.Entity> data = new HashMap<Key, DatastorePb.GetResponse.Entity>();
        MemcacheService memcache = MemvacheDelegate.getMemcache();
        Map all = memcache.getAll(requestKeys);
        for (Key key : all.keySet()) {
            DatastorePb.GetResponse.Entity entity = (DatastorePb.GetResponse.Entity)all.get(key);
            if (entity == null) continue;
            OnestoreEntity.Reference currentKey = KeyTranslatorPublic.convertToPb(key);
            entity.getEntity().setKey(currentKey);
            data.put(key, entity);
        }
        if (requestKeys.size() == data.size()) {
            DatastorePb.GetResponse responsePb = new DatastorePb.GetResponse();
            responsePb.mutableEntitys();
            responsePb.mutableDeferreds();
            for (Key key : requestKeys) {
                DatastorePb.GetResponse.Entity entity = (DatastorePb.GetResponse.Entity)data.get(key);
                if (entity == null) {
                    data.remove(key);
                    continue;
                }
                responsePb.addEntity(entity);
            }
            return Pair.response(responsePb.toByteArray());
        }
        for (int i = requestKeys.size() - 1; 0 <= i; --i) {
            if (!data.containsKey(requestKeys.get(i))) continue;
            requestPb.removeKey(i);
        }
        byte[] reconstructured = requestPb.toByteArray();
        DatastorePb.GetRequest reconstRequest = new DatastorePb.GetRequest();
        reconstRequest.mergeFrom(reconstructured);
        this.requestKeysMap.put(reconstRequest, requestKeys);
        this.dataMap.put(reconstRequest, data);
        Integer count = this.requestCountMap.get(reconstRequest);
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        this.requestCountMap.put(reconstRequest, count);
        return Pair.request(reconstructured);
    }

    @Override
    public byte[] post_datastore_v3_Get(DatastorePb.GetRequest requestPb, DatastorePb.GetResponse responsePb) {
        List<Key> requestKeys;
        Map<Key, DatastorePb.GetResponse.Entity> data;
        if (requestPb.getTransaction().hasApp()) {
            return null;
        }
        HashMap<Key, DatastorePb.GetResponse.Entity> newMap = new HashMap<Key, DatastorePb.GetResponse.Entity>();
        List keys = requestPb.keys();
        List entitys = responsePb.entitys();
        for (int i = 0; i < entitys.size(); ++i) {
            Key key = PbKeyUtil.toKey((OnestoreEntity.Reference)keys.get(i));
            DatastorePb.GetResponse.Entity entity = (DatastorePb.GetResponse.Entity)entitys.get(i);
            newMap.put(key, entity);
        }
        MemcacheService memcache = MemvacheDelegate.getMemcache();
        memcache.putAll(newMap);
        Integer count = this.requestCountMap.get(requestPb);
        if (count == 1) {
            data = this.dataMap.remove(requestPb);
            requestKeys = this.requestKeysMap.remove(requestPb);
            this.requestCountMap.put(requestPb, 0);
        } else {
            data = this.dataMap.get(requestPb);
            requestKeys = this.requestKeysMap.get(requestPb);
            this.requestCountMap.put(requestPb, count - 1);
        }
        data.putAll(newMap);
        responsePb.clearEntity();
        for (Key key : requestKeys) {
            responsePb.addEntity(data.get(key));
        }
        return responsePb.toByteArray();
    }

    @Override
    public byte[] post_datastore_v3_Put(DatastorePb.PutRequest requestPb, DatastorePb.PutResponse responsePb) {
        DatastorePb.Transaction tx = requestPb.getTransaction();
        if (tx.hasApp()) {
            long handle = tx.getHandle();
            Map<Key, DatastorePb.GetResponse.Entity> newMap = this.extractCache(requestPb, responsePb);
            if (this.putUnderTx.containsKey(handle)) {
                Map<Key, DatastorePb.GetResponse.Entity> cached = this.putUnderTx.get(handle);
                cached.putAll(newMap);
            } else {
                this.putUnderTx.put(handle, newMap);
            }
        } else {
            MemcacheService memcache = MemvacheDelegate.getMemcache();
            Map<Key, DatastorePb.GetResponse.Entity> newMap = this.extractCache(requestPb, responsePb);
            memcache.putAll(newMap);
        }
        return null;
    }

    private Map<Key, DatastorePb.GetResponse.Entity> extractCache(DatastorePb.PutRequest requestPb, DatastorePb.PutResponse responsePb) {
        HashMap<Key, DatastorePb.GetResponse.Entity> newMap = new HashMap<Key, DatastorePb.GetResponse.Entity>();
        int size = requestPb.entitySize();
        List entitys = requestPb.entitys();
        for (int i = 0; i < size; ++i) {
            OnestoreEntity.EntityProto proto = (OnestoreEntity.EntityProto)entitys.get(i);
            OnestoreEntity.Reference reference = responsePb.getKey(i);
            Key key = PbKeyUtil.toKey(reference);
            DatastorePb.GetResponse.Entity entity = new DatastorePb.GetResponse.Entity();
            entity.setEntity(proto);
            entity.setKey(reference);
            newMap.put(key, entity);
        }
        return newMap;
    }

    @Override
    public Pair<byte[], byte[]> pre_datastore_v3_Delete(DatastorePb.DeleteRequest requestPb) {
        List<Key> keys = PbKeyUtil.toKeys(requestPb.keys());
        MemcacheService memcache = MemvacheDelegate.getMemcache();
        memcache.deleteAll(keys);
        return null;
    }

    @Override
    public byte[] post_datastore_v3_Commit(DatastorePb.Transaction requestPb, DatastorePb.CommitResponse responsePb) {
        long handle = requestPb.getHandle();
        if (this.putUnderTx.containsKey(handle)) {
            Map<Key, DatastorePb.GetResponse.Entity> map = this.putUnderTx.get(handle);
            MemvacheDelegate.getMemcache().putAll(map);
            return null;
        }
        return null;
    }

    @Override
    public byte[] post_datastore_v3_Rollback(DatastorePb.Transaction requestPb, DatastorePb.CommitResponse responsePb) {
        long handle = requestPb.getHandle();
        if (this.putUnderTx.containsKey(handle)) {
            this.putUnderTx.remove(handle);
        }
        return null;
    }
}

