/*
 * Decompiled with CFR 0.152.
 */
package net.vvakame.memvache;

import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.apphosting.api.ApiProxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.vvakame.memvache.AggressiveQueryCacheStrategy;
import net.vvakame.memvache.GetPutCacheStrategy;
import net.vvakame.memvache.Pair;
import net.vvakame.memvache.QueryKeysOnlyStrategy;
import net.vvakame.memvache.RpcVisitor;
import net.vvakame.memvache.SniffFuture;
import net.vvakame.memvache.Strategy;

public class MemvacheDelegate
implements ApiProxy.Delegate<ApiProxy.Environment> {
    static final Logger logger = Logger.getLogger(MemvacheDelegate.class.getName());
    static final ThreadLocal<MemvacheDelegate> localThis = new ThreadLocal();
    final ApiProxy.Delegate<ApiProxy.Environment> parent;
    ThreadLocal<List<Strategy>> strategies = new ThreadLocal();
    static final Comparator<Strategy> strategyComparator = new StrategyComparator();
    static Set<Class<? extends Strategy>> enabledStrategies = new LinkedHashSet<Class<? extends Strategy>>();

    static void staticInitialize() {
        enabledStrategies.clear();
        MemvacheDelegate.addStrategy(AggressiveQueryCacheStrategy.class);
        MemvacheDelegate.addStrategy(QueryKeysOnlyStrategy.class);
        MemvacheDelegate.addStrategy(GetPutCacheStrategy.class);
        RpcVisitor.debug = false;
    }

    public static MemvacheDelegate get() {
        return localThis.get();
    }

    public static MemvacheDelegate install() {
        ApiProxy.Delegate originalDelegate = ApiProxy.getDelegate();
        if (!(originalDelegate instanceof MemvacheDelegate)) {
            MemvacheDelegate newDelegate = new MemvacheDelegate((ApiProxy.Delegate<ApiProxy.Environment>)originalDelegate);
            MemvacheDelegate.setupStrategies(newDelegate);
            ApiProxy.setDelegate((ApiProxy.Delegate)newDelegate);
            localThis.set(newDelegate);
            return newDelegate;
        }
        MemvacheDelegate delegate = (MemvacheDelegate)originalDelegate;
        MemvacheDelegate.setupStrategies(delegate);
        return delegate;
    }

    public static void addStrategy(Class<? extends Strategy> clazz) {
        enabledStrategies.add(clazz);
    }

    public static void removeStrategy(Class<? extends Strategy> clazz) {
        enabledStrategies.remove(clazz);
    }

    static void setupStrategies(MemvacheDelegate memvache) {
        List<Strategy> strategies = memvache.strategies.get();
        if (strategies == null) {
            strategies = new ArrayList<Strategy>(3);
            memvache.strategies.set(strategies);
        } else {
            strategies.clear();
        }
        try {
            for (Class<? extends Strategy> clazz : enabledStrategies) {
                strategies.add(clazz.newInstance());
            }
            Collections.sort(strategies, strategyComparator);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void uninstall(ApiProxy.Delegate<ApiProxy.Environment> originalDelegate) {
        localThis.set(null);
        ApiProxy.setDelegate(originalDelegate);
    }

    public void uninstall() {
        localThis.set(null);
        ApiProxy.setDelegate(this.parent);
    }

    public Future<byte[]> makeAsyncCall(ApiProxy.Environment env, String service, String method, byte[] requestBytes, ApiProxy.ApiConfig config) {
        return this.processAsyncCall(env, service, method, requestBytes, config, 0);
    }

    Future<byte[]> processAsyncCall(ApiProxy.Environment env, final String service, final String method, final byte[] requestBytes, ApiProxy.ApiConfig config, int depth) {
        List<Strategy> strategies = this.strategies.get();
        if (strategies == null) {
            return this.getParent().makeAsyncCall(env, service, method, requestBytes, config);
        }
        if (strategies.size() == depth) {
            return this.getParent().makeAsyncCall(env, service, method, requestBytes, config);
        }
        final Strategy strategy = strategies.get(depth);
        final Pair<byte[], byte[]> pair = strategy.preProcess(service, method, requestBytes);
        if (pair != null && pair.response != null) {
            return this.createFuture((byte[])pair.response);
        }
        Future<byte[]> response = pair != null && pair.request != null ? this.processAsyncCall(env, service, method, (byte[])pair.request, config, depth + 1) : this.processAsyncCall(env, service, method, requestBytes, config, depth + 1);
        return new SniffFuture<byte[]>(response){

            @Override
            public byte[] processDate(byte[] data) {
                byte[] modified = pair != null && pair.request != null ? strategy.postProcess(service, method, (byte[])pair.request, data) : strategy.postProcess(service, method, requestBytes, data);
                if (modified != null) {
                    return modified;
                }
                return data;
            }
        };
    }

    public byte[] makeSyncCall(ApiProxy.Environment env, String service, String method, byte[] requestBytes) throws ApiProxy.ApiProxyException {
        return this.processSyncCall(env, service, method, requestBytes, 0);
    }

    byte[] processSyncCall(ApiProxy.Environment env, String service, String method, byte[] requestBytes, int depth) {
        List<Strategy> strategies = this.strategies.get();
        if (strategies == null) {
            return this.getParent().makeSyncCall(env, service, method, requestBytes);
        }
        if (strategies.size() == depth) {
            return this.getParent().makeSyncCall(env, service, method, requestBytes);
        }
        Strategy strategy = strategies.get(depth);
        Pair<byte[], byte[]> pair = strategy.preProcess(service, method, requestBytes);
        if (pair != null && pair.response != null) {
            return (byte[])pair.response;
        }
        byte[] response = pair != null && pair.request != null ? this.processSyncCall(env, service, method, (byte[])pair.request, depth + 1) : this.processSyncCall(env, service, method, requestBytes, depth + 1);
        byte[] modified = strategy.postProcess(service, method, requestBytes, response);
        if (modified != null) {
            return modified;
        }
        return response;
    }

    public static MemcacheService getMemcache() {
        return MemcacheServiceFactory.getMemcacheService((String)"memvache");
    }

    Future<byte[]> createFuture(final byte[] data) {
        return new Future<byte[]>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public byte[] get() {
                return data;
            }

            @Override
            public byte[] get(long timeout, TimeUnit unit) {
                return data;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }
        };
    }

    MemvacheDelegate(ApiProxy.Delegate<ApiProxy.Environment> delegate) {
        this.parent = delegate;
    }

    public void log(ApiProxy.Environment env, ApiProxy.LogRecord logRecord) {
        this.getParent().log(env, logRecord);
    }

    public void flushLogs(ApiProxy.Environment env) {
        this.getParent().flushLogs(env);
    }

    public List<Thread> getRequestThreads(ApiProxy.Environment env) {
        return this.getParent().getRequestThreads(env);
    }

    public ApiProxy.Delegate<ApiProxy.Environment> getParent() {
        return this.parent;
    }

    static {
        MemvacheDelegate.staticInitialize();
    }

    static class StrategyComparator
    implements Comparator<Strategy> {
        StrategyComparator() {
        }

        @Override
        public int compare(Strategy s1, Strategy s2) {
            return s1.getPriority() - s2.getPriority();
        }
    }
}

